/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.sql.MalformedDataMapCommandException;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapDistributable;
import org.apache.carbondata.core.datamap.DataMapLevel;
import org.apache.carbondata.core.datamap.DataMapMeta;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.datamap.dev.DataMapBuilder;
import org.apache.carbondata.core.datamap.dev.DataMapFactory;
import org.apache.carbondata.core.datamap.dev.DataMapModel;
import org.apache.carbondata.core.datamap.dev.DataMapWriter;
import org.apache.carbondata.core.datamap.dev.cgdatamap.CoarseGrainDataMap;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.DataMapSchema;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.datamap.bloom.BloomCoarseGrainDataMap;
import org.apache.carbondata.datamap.bloom.BloomDataMapBuilder;
import org.apache.carbondata.datamap.bloom.BloomDataMapDistributable;
import org.apache.carbondata.datamap.bloom.BloomDataMapWriter;
import org.apache.carbondata.events.Event;
import org.apache.commons.lang3.StringUtils;

@InterfaceAudience.Internal
public class BloomCoarseGrainDataMapFactory
extends DataMapFactory<CoarseGrainDataMap> {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)BloomCoarseGrainDataMapFactory.class.getName());
    private static final String BLOOM_SIZE = "bloom_size";
    private static final int DEFAULT_BLOOM_FILTER_SIZE = 32000;
    private static final String BLOOM_FPP = "bloom_fpp";
    private static final double DEFAULT_BLOOM_FILTER_FPP = 0.01;
    private static final String COMPRESS_BLOOM = "bloom_compress";
    private static final boolean DEFAULT_BLOOM_COMPRESS = true;
    private DataMapMeta dataMapMeta;
    private String dataMapName;
    private int bloomFilterSize;
    private double bloomFilterFpp;
    private boolean bloomCompress;

    public BloomCoarseGrainDataMapFactory(CarbonTable carbonTable, DataMapSchema dataMapSchema) throws MalformedDataMapCommandException {
        super(carbonTable, dataMapSchema);
        Objects.requireNonNull(carbonTable);
        Objects.requireNonNull(dataMapSchema);
        this.dataMapName = dataMapSchema.getDataMapName();
        List indexedColumns = carbonTable.getIndexedColumns(dataMapSchema);
        this.bloomFilterSize = this.validateAndGetBloomFilterSize(dataMapSchema);
        this.bloomFilterFpp = this.validateAndGetBloomFilterFpp(dataMapSchema);
        this.bloomCompress = this.validateAndGetBloomCompress(dataMapSchema);
        ArrayList<ExpressionType> optimizedOperations = new ArrayList<ExpressionType>();
        optimizedOperations.add(ExpressionType.EQUALS);
        this.dataMapMeta = new DataMapMeta(this.dataMapName, indexedColumns, optimizedOperations);
        LOGGER.info(String.format("DataMap %s works for %s with bloom size %d", this.dataMapName, this.dataMapMeta, this.bloomFilterSize));
    }

    private int validateAndGetBloomFilterSize(DataMapSchema dmSchema) throws MalformedDataMapCommandException {
        int bloomFilterSize;
        String bloomFilterSizeStr = (String)dmSchema.getProperties().get(BLOOM_SIZE);
        if (StringUtils.isBlank((CharSequence)bloomFilterSizeStr)) {
            LOGGER.warn(String.format("Bloom filter size is not configured for datamap %s, use default value %d", this.dataMapName, 32000));
            return 32000;
        }
        try {
            bloomFilterSize = Integer.parseInt(bloomFilterSizeStr);
        }
        catch (NumberFormatException e) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter size '%s', it should be an integer", bloomFilterSizeStr));
        }
        if (bloomFilterSize <= 0) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter size '%s', it should be greater than 0", bloomFilterSizeStr));
        }
        return bloomFilterSize;
    }

    private double validateAndGetBloomFilterFpp(DataMapSchema dmSchema) throws MalformedDataMapCommandException {
        double bloomFilterFpp;
        String bloomFilterFppStr = (String)dmSchema.getProperties().get(BLOOM_FPP);
        if (StringUtils.isBlank((CharSequence)bloomFilterFppStr)) {
            LOGGER.warn(String.format("Bloom filter FPP is not configured for datamap %s, use default value %f", this.dataMapName, 0.01));
            return 0.01;
        }
        try {
            bloomFilterFpp = Double.parseDouble(bloomFilterFppStr);
        }
        catch (NumberFormatException e) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter fpp '%s', it should be an numeric", bloomFilterFppStr));
        }
        if (bloomFilterFpp < 0.0 || bloomFilterFpp - 1.0 >= 0.0) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter fpp '%s', it should be in range 0~1", bloomFilterFppStr));
        }
        return bloomFilterFpp;
    }

    private boolean validateAndGetBloomCompress(DataMapSchema dmSchema) {
        String bloomCompress = (String)dmSchema.getProperties().get(COMPRESS_BLOOM);
        if (StringUtils.isBlank((CharSequence)bloomCompress)) {
            LOGGER.warn(String.format("Bloom compress is not configured for datamap %s, use default value %b", this.dataMapName, true));
            return true;
        }
        return Boolean.parseBoolean(bloomCompress);
    }

    public DataMapWriter createWriter(Segment segment, String shardName) throws IOException {
        LOGGER.info(String.format("Data of BloomCoarseGranDataMap %s for table %s will be written to %s", this.dataMapName, this.getCarbonTable().getTableName(), shardName));
        return new BloomDataMapWriter(this.getCarbonTable().getTablePath(), this.dataMapName, this.dataMapMeta.getIndexedColumns(), segment, shardName, this.bloomFilterSize, this.bloomFilterFpp, this.bloomCompress);
    }

    public DataMapBuilder createBuilder(Segment segment, String shardName) throws IOException {
        return new BloomDataMapBuilder(this.getCarbonTable().getTablePath(), this.dataMapName, this.dataMapMeta.getIndexedColumns(), segment, shardName, this.bloomFilterSize, this.bloomFilterFpp, this.bloomCompress);
    }

    public List<CoarseGrainDataMap> getDataMaps(Segment segment) throws IOException {
        ArrayList<CoarseGrainDataMap> dataMaps = new ArrayList<CoarseGrainDataMap>(1);
        try {
            CarbonFile[] carbonFiles;
            String dataMapStorePath = DataMapWriter.getDefaultDataMapPath((String)this.getCarbonTable().getTablePath(), (String)segment.getSegmentNo(), (String)this.dataMapName);
            for (CarbonFile carbonFile : carbonFiles = FileFactory.getCarbonFile((String)dataMapStorePath).listFiles()) {
                BloomCoarseGrainDataMap bloomDM = new BloomCoarseGrainDataMap();
                bloomDM.init(new DataMapModel(carbonFile.getAbsolutePath()));
                bloomDM.setIndexedColumn(new HashSet<String>(this.dataMapMeta.getIndexedColumnNames()));
                dataMaps.add(bloomDM);
            }
        }
        catch (Exception e) {
            throw new IOException("Error occurs while init Bloom DataMap", e);
        }
        return dataMaps;
    }

    public List<CoarseGrainDataMap> getDataMaps(DataMapDistributable distributable) throws IOException {
        ArrayList<CoarseGrainDataMap> coarseGrainDataMaps = new ArrayList<CoarseGrainDataMap>();
        BloomCoarseGrainDataMap bloomCoarseGrainDataMap = new BloomCoarseGrainDataMap();
        String indexPath = ((BloomDataMapDistributable)distributable).getIndexPath();
        bloomCoarseGrainDataMap.init(new DataMapModel(indexPath));
        bloomCoarseGrainDataMap.setIndexedColumn(new HashSet<String>(this.dataMapMeta.getIndexedColumnNames()));
        coarseGrainDataMaps.add(bloomCoarseGrainDataMap);
        return coarseGrainDataMaps;
    }

    private CarbonFile[] getAllIndexDirs(String tablePath, String segmentId) {
        List dataMaps;
        ArrayList<CarbonFile> indexDirs = new ArrayList<CarbonFile>();
        try {
            dataMaps = DataMapStoreManager.getInstance().getAllDataMap(this.getCarbonTable());
        }
        catch (IOException ex) {
            LOGGER.error((Throwable)ex, String.format("failed to get datamaps for tablePath %s, segmentId %s", tablePath, segmentId));
            throw new RuntimeException(ex);
        }
        if (dataMaps.size() > 0) {
            for (TableDataMap dataMap : dataMaps) {
                String dmPath = CarbonTablePath.getSegmentPath((String)tablePath, (String)segmentId) + File.separator + dataMap.getDataMapSchema().getDataMapName();
                FileFactory.FileType fileType = FileFactory.getFileType((String)dmPath);
                CarbonFile dirPath = FileFactory.getCarbonFile((String)dmPath, (FileFactory.FileType)fileType);
                List<CarbonFile> indexFiles = Arrays.asList(dirPath.listFiles(new CarbonFileFilter(){

                    public boolean accept(CarbonFile file) {
                        return file.isDirectory();
                    }
                }));
                indexDirs.addAll(indexFiles);
            }
        }
        return indexDirs.toArray(new CarbonFile[0]);
    }

    public List<DataMapDistributable> toDistributable(Segment segment) {
        ArrayList<DataMapDistributable> dataMapDistributableList = new ArrayList<DataMapDistributable>();
        CarbonFile[] indexDirs = this.getAllIndexDirs(this.getCarbonTable().getTablePath(), segment.getSegmentNo());
        if (segment.getFilteredIndexShardNames().size() == 0) {
            for (CarbonFile indexDir : indexDirs) {
                BloomDataMapDistributable bloomDataMapDistributable = new BloomDataMapDistributable(indexDir.getAbsolutePath());
                dataMapDistributableList.add(bloomDataMapDistributable);
            }
            return dataMapDistributableList;
        }
        for (CarbonFile indexDir : indexDirs) {
            if (!segment.getFilteredIndexShardNames().contains(indexDir.getName())) continue;
            BloomDataMapDistributable bloomDataMapDistributable = new BloomDataMapDistributable(indexDir.getAbsolutePath());
            dataMapDistributableList.add(bloomDataMapDistributable);
        }
        return dataMapDistributableList;
    }

    public void fireEvent(Event event) {
    }

    public void clear(Segment segment) {
    }

    public void clear() {
    }

    public void deleteDatamapData() {
        SegmentStatusManager ssm = new SegmentStatusManager(this.getCarbonTable().getAbsoluteTableIdentifier());
        try {
            List validSegments = ssm.getValidAndInvalidSegments().getValidSegments();
            for (Segment segment : validSegments) {
                String segmentId = segment.getSegmentNo();
                String datamapPath = CarbonTablePath.getSegmentPath((String)this.getCarbonTable().getAbsoluteTableIdentifier().getTablePath(), (String)segmentId) + File.separator + this.dataMapName;
                if (!FileFactory.isFileExist((String)datamapPath)) continue;
                CarbonFile file = FileFactory.getCarbonFile((String)datamapPath, (FileFactory.FileType)FileFactory.getFileType((String)datamapPath));
                CarbonUtil.deleteFoldersAndFilesSilent((CarbonFile[])new CarbonFile[]{file});
            }
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.error("drop datamap failed, failed to delete datamap directory");
        }
    }

    public boolean willBecomeStale(TableOperation operation) {
        return false;
    }

    public DataMapMeta getMeta() {
        return this.dataMapMeta;
    }

    public DataMapLevel getDataMapLevel() {
        return DataMapLevel.CG;
    }
}

