/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.dev.DataMapModel;
import org.apache.carbondata.core.datamap.dev.cgdatamap.CoarseGrainDataMap;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.datamap.bloom.BloomDMModel;
import org.apache.carbondata.datamap.bloom.BloomDataMapCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.bloom.Key;

@InterfaceAudience.Internal
public class BloomCoarseGrainDataMap
extends CoarseGrainDataMap {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)BloomCoarseGrainDataMap.class.getName());
    public static final String BLOOM_INDEX_SUFFIX = ".bloomindex";
    private Set<String> indexedColumn;
    private List<BloomDMModel> bloomIndexList;
    private String shardName;
    private BloomDataMapCache bloomDataMapCache;
    private Path indexPath;

    public void init(DataMapModel dataMapModel) throws IOException {
        this.indexPath = FileFactory.getPath((String)dataMapModel.getFilePath());
        this.shardName = this.indexPath.getName();
        FileSystem fs = FileFactory.getFileSystem((Path)this.indexPath);
        if (!fs.exists(this.indexPath)) {
            throw new IOException(String.format("Path %s for Bloom index dataMap does not exist", this.indexPath));
        }
        if (!fs.isDirectory(this.indexPath)) {
            throw new IOException(String.format("Path %s for Bloom index dataMap must be a directory", this.indexPath));
        }
        this.bloomDataMapCache = BloomDataMapCache.getInstance();
    }

    public void setIndexedColumn(Set<String> indexedColumn) {
        this.indexedColumn = indexedColumn;
    }

    public List<Blocklet> prune(FilterResolverIntf filterExp, SegmentProperties segmentProperties, List<PartitionSpec> partitions) {
        ArrayList<Blocklet> hitBlocklets = new ArrayList<Blocklet>();
        if (filterExp == null) {
            return null;
        }
        List<BloomQueryModel> bloomQueryModels = this.getQueryValue(filterExp.getFilterExpression());
        for (BloomQueryModel bloomQueryModel : bloomQueryModels) {
            LOGGER.debug("prune blocklet for query: " + bloomQueryModel);
            BloomDataMapCache.CacheKey cacheKey = new BloomDataMapCache.CacheKey(this.indexPath.toString(), bloomQueryModel.columnName);
            List<BloomDMModel> bloomDMModels = this.bloomDataMapCache.getBloomDMModelByKey(cacheKey);
            for (BloomDMModel bloomDMModel : bloomDMModels) {
                boolean scanRequired = bloomDMModel.getBloomFilter().membershipTest(new Key(this.convertValueToBytes(bloomQueryModel.dataType, bloomQueryModel.filterValue)));
                if (scanRequired) {
                    LOGGER.debug(String.format("BloomCoarseGrainDataMap: Need to scan -> blocklet#%s", String.valueOf(bloomDMModel.getBlockletNo())));
                    Blocklet blocklet = new Blocklet(this.shardName, String.valueOf(bloomDMModel.getBlockletNo()));
                    hitBlocklets.add(blocklet);
                    continue;
                }
                LOGGER.debug(String.format("BloomCoarseGrainDataMap: Skip scan -> blocklet#%s", String.valueOf(bloomDMModel.getBlockletNo())));
            }
        }
        return hitBlocklets;
    }

    private byte[] convertValueToBytes(DataType dataType, Object value) {
        try {
            if (dataType == DataTypes.STRING) {
                if (value instanceof byte[]) {
                    return (byte[])value;
                }
                return String.valueOf(value).getBytes("utf-8");
            }
            return CarbonUtil.getValueAsBytes((DataType)dataType, (Object)value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error occurs while converting " + value + " to " + dataType, e);
        }
    }

    private List<BloomQueryModel> getQueryValue(Expression expression) {
        ArrayList<BloomQueryModel> queryModels = new ArrayList<BloomQueryModel>();
        if (expression instanceof EqualToExpression) {
            Expression left = ((EqualToExpression)expression).getLeft();
            Expression right = ((EqualToExpression)expression).getRight();
            if (left instanceof ColumnExpression && right instanceof LiteralExpression) {
                String column = ((ColumnExpression)left).getColumnName();
                if (this.indexedColumn.contains(column)) {
                    DataType dataType = ((ColumnExpression)left).getDataType();
                    Object value = ((LiteralExpression)right).getLiteralExpValue();
                    BloomQueryModel bloomQueryModel = new BloomQueryModel(column, dataType, value);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
            if (left instanceof LiteralExpression && right instanceof ColumnExpression) {
                String column = ((ColumnExpression)right).getColumnName();
                if (this.indexedColumn.contains(column)) {
                    DataType dataType = ((ColumnExpression)right).getDataType();
                    Object value = ((LiteralExpression)left).getLiteralExpValue();
                    BloomQueryModel bloomQueryModel = new BloomQueryModel(column, dataType, value);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
        }
        for (Expression child : expression.getChildren()) {
            queryModels.addAll(this.getQueryValue(child));
        }
        return queryModels;
    }

    public boolean isScanRequired(FilterResolverIntf filterExp) {
        return true;
    }

    public void clear() {
        this.bloomIndexList.clear();
        this.bloomIndexList = null;
    }

    public static String getBloomIndexFile(String shardPath, String colName) {
        return shardPath.concat(File.separator).concat(colName).concat(BLOOM_INDEX_SUFFIX);
    }

    public void finish() {
    }

    static class BloomQueryModel {
        private String columnName;
        private DataType dataType;
        private Object filterValue;

        private BloomQueryModel(String columnName, DataType dataType, Object filterValue) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.filterValue = filterValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("BloomQueryModel{");
            sb.append("columnName='").append(this.columnName).append('\'');
            sb.append(", dataType=").append(this.dataType);
            sb.append(", filterValue=").append(this.filterValue);
            sb.append('}');
            return sb.toString();
        }
    }
}

