/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.GenerateMicroBenchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class StatementTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenerateMicroBenchmark
    public String prepareBindExecute(HrConnection state) throws SQLException {
        Connection con = state.con;
        PreparedStatement st = null;
        ResultSet rs = null;
        String ename = null;
        try {
            PreparedStatement ps;
            st = ps = con.prepareStatement("select name from emps where empid = ?");
            ps.setInt(1, state.id);
            rs = ps.executeQuery();
            rs.next();
            ename = rs.getString(1);
        }
        catch (Throwable throwable) {
            StatementTest.close(rs, st);
            throw throwable;
        }
        StatementTest.close(rs, st);
        return ename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenerateMicroBenchmark
    public String bindExecute(HrPreparedStatement state) throws SQLException {
        PreparedStatement st = state.ps;
        ResultSet rs = null;
        String ename = null;
        try {
            st.setInt(1, state.id);
            rs = st.executeQuery();
            rs.next();
            ename = rs.getString(1);
        }
        catch (Throwable throwable) {
            StatementTest.close(rs, null);
            throw throwable;
        }
        StatementTest.close(rs, null);
        return ename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenerateMicroBenchmark
    public String executeQuery(HrConnection state) throws SQLException {
        Connection con = state.con;
        Statement st = null;
        ResultSet rs = null;
        String ename = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("select name from emps where empid = " + state.id);
            rs.next();
            ename = rs.getString(1);
        }
        catch (Throwable throwable) {
            StatementTest.close(rs, st);
            throw throwable;
        }
        StatementTest.close(rs, st);
        return ename;
    }

    @GenerateMicroBenchmark
    public String forEach(HrConnection state) throws SQLException {
        Employee[] emps;
        for (Employee emp : emps = state.hr.emps) {
            if (emp.empid != state.id) continue;
            return emp.name;
        }
        return null;
    }

    private static void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class Department {
        public final int deptno;
        public final String name;
        public final List<Employee> employees;

        public Department(int deptno, String name, List<Employee> employees) {
            this.deptno = deptno;
            this.name = name;
            this.employees = employees;
        }

        public String toString() {
            return "Department [deptno: " + this.deptno + ", name: " + this.name + ", employees: " + this.employees + "]";
        }
    }

    public static class Employee {
        public final int empid;
        public final int deptno;
        public final String name;
        public final float salary;
        public final Integer commission;

        public Employee(int empid, int deptno, String name, float salary, Integer commission) {
            this.empid = empid;
            this.deptno = deptno;
            this.name = name;
            this.salary = salary;
            this.commission = commission;
        }

        public String toString() {
            return "Employee [empid: " + this.empid + ", deptno: " + this.deptno + ", name: " + this.name + "]";
        }
    }

    public static class HrSchema {
        public final Employee[] emps = new Employee[]{new Employee(100, 10, "Bill", 10000.0f, 1000), new Employee(200, 20, "Eric", 8000.0f, 500), new Employee(150, 10, "Sebastian", 7000.0f, null), new Employee(110, 10, "Theodore", 11500.0f, 250)};
        public final Department[] depts = new Department[]{new Department(10, "Sales", Arrays.asList(this.emps[0], this.emps[2])), new Department(30, "Marketing", Collections.<Employee>emptyList()), new Department(40, "HR", Collections.singletonList(this.emps[1]))};

        public String toString() {
            return "HrSchema";
        }
    }

    public static class HrPreparedStatement
    extends HrConnection {
        PreparedStatement ps;

        public HrPreparedStatement() {
            try {
                this.ps = this.con.prepareStatement("select name from emps where empid = ?");
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @State(value=Scope.Thread)
    @BenchmarkMode(value={Mode.AverageTime})
    public static class HrConnection {
        Connection con;
        int id;
        HrSchema hr = new HrSchema();
        Random rnd = new Random();

        public HrConnection() {
            OptiqConnection optiqConnection;
            Connection connection;
            try {
                Class.forName("net.hydromatic.optiq.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            try {
                Properties info = new Properties();
                info.put("lex", "JAVA");
                info.put("quoting", "DOUBLE_QUOTE");
                connection = DriverManager.getConnection("jdbc:calcite:", info);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            try {
                optiqConnection = connection.unwrap(OptiqConnection.class);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            SchemaPlus rootSchema = optiqConnection.getRootSchema();
            rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
            try {
                optiqConnection.setSchema("hr");
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            this.con = connection;
        }

        @Setup(value=Level.Iteration)
        public void pickEmployee() {
            this.id = this.hr.emps[this.rnd.nextInt((int)4)].empid;
        }
    }
}

