/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.Matchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ServerTest {
    static final String URL = "jdbc:calcite:";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    static Connection connect() throws SQLException {
        return DriverManager.getConnection(URL, CalciteAssert.propBuilder().set(CalciteConnectionProperty.PARSER_FACTORY, SqlDdlParserImpl.class.getName() + "#FACTORY").set(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED, "true").build());
    }

    @Test
    public void testStatement() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();
             ResultSet r = s.executeQuery("values 1, 2");){
            MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)r.getString(1), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void testCreateSchema() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            boolean b = s.execute("create schema s");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create table s.t (i int not null)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            int x = s.executeUpdate("insert into s.t values 1");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            try (ResultSet r = s.executeQuery("select count(*) from s.t");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)1));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
        }
    }

    @Test
    public void testCreateType() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            boolean b = s.execute("create type mytype1 as BIGINT");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create or replace type mytype2 as (i int not null, jj mytype1)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create type mytype3 as (i int not null, jj mytype2)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create or replace type mytype1 as DOUBLE");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create table t (c mytype1 NOT NULL)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("create type mytype4 as BIGINT");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            int x = s.executeUpdate("insert into t values 12.0");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t values 3.0");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            try (ResultSet r = s.executeQuery("select CAST(c AS mytype4) from t");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)12));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)3));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
        }
    }

    @Test
    public void testDropType() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            boolean b = s.execute("create type mytype1 as BIGINT");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            b = s.execute("drop type mytype1");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void testCreateTable() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            boolean b = s.execute("create table t (i int not null)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            int x = s.executeUpdate("insert into t values 1");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t values 3");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            try (ResultSet r = s.executeQuery("select sum(i) from t");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)4));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
        }
    }

    @Test
    public void testStoredGeneratedColumn() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            String sql0 = "create table t (\n h int not null,\n i int,\n j int as (i + 1) stored)";
            boolean b = s.execute("create table t (\n h int not null,\n i int,\n j int as (i + 1) stored)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            int x = s.executeUpdate("insert into t (h, i) values (3, 4)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            String sql1 = "explain plan for\ninsert into t (h, i) values (3, 4)";
            try (ResultSet r = s.executeQuery("explain plan for\ninsert into t (h, i) values (3, 4)");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                String plan = "EnumerableTableModify(table=[[T]], operation=[INSERT], flattened=[false])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], proj#0..1=[{exprs}], J=[$t3])\n    EnumerableValues(tuples=[[{ 3, 4 }]])\n";
                MatcherAssert.assertThat((Object)r.getString(1), (Matcher)Matchers.isLinux((String)"EnumerableTableModify(table=[[T]], operation=[INSERT], flattened=[false])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], proj#0..1=[{exprs}], J=[$t3])\n    EnumerableValues(tuples=[[{ 3, 4 }]])\n"));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
            r = s.executeQuery("select * from t");
            var10_17 = null;
            try {
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt("H"), (Matcher)Is.is((Object)3));
                MatcherAssert.assertThat((Object)r.wasNull(), (Matcher)Is.is((Object)false));
                MatcherAssert.assertThat((Object)r.getInt("I"), (Matcher)Is.is((Object)4));
                MatcherAssert.assertThat((Object)r.getInt("J"), (Matcher)Is.is((Object)5));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
            catch (Throwable throwable) {
                var10_17 = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    ServerTest.$closeResource(var10_17, r);
                }
            }
            try {
                x = s.executeUpdate("insert into t values (2, 3)");
                Assert.fail((String)("expected error, got " + x));
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Number of INSERT target columns (3) does not equal number of source items (2)"));
            }
            try {
                x = s.executeUpdate("insert into t values (3, 4, 5, 6)");
                Assert.fail((String)("expected error, got " + x));
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Number of INSERT target columns (3) does not equal number of source items (4)"));
            }
            try {
                x = s.executeUpdate("insert into t values (3, 4, 5)");
                Assert.fail((String)("expected error, got " + x));
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot INSERT into generated column 'J'"));
            }
            x = s.executeUpdate("insert into t (h, i) values (1, 2)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t (h, i, j) values (1, 2, DEFAULT)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t (h, j, i) values (1, DEFAULT, 3)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            try {
                x = s.executeUpdate("insert into t (h, j) values (1, 3)");
                Assert.fail((String)("expected error, got " + x));
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot INSERT into generated column 'J'"));
            }
            try {
                x = s.executeUpdate("insert into t (h, i, j) values (2, 3, 3 + 1)");
                Assert.fail((String)("expected error, got " + x));
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot INSERT into generated column 'J'"));
            }
            x = s.executeUpdate("insert into t (h, i) values (0, 1)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t (h, i, j) values (0, 1, DEFAULT)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t (j, i, h) values (DEFAULT, NULL, 7)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            x = s.executeUpdate("insert into t (h, i) values (6, 5), (7, 4)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)2));
            r = s.executeQuery("select sum(i), count(*) from t");
            var10_17 = null;
            try {
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)19));
                MatcherAssert.assertThat((Object)r.getInt(2), (Matcher)Is.is((Object)9));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
            catch (Throwable throwable) {
                var10_17 = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    ServerTest.$closeResource(var10_17, r);
                }
            }
        }
    }

    @Ignore(value="not working yet")
    @Test
    public void testStoredGeneratedColumn2() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            String sql = "create table t (\n h int not null,\n i int,\n j int as (i + 1) stored)";
            boolean b = s.execute("create table t (\n h int not null,\n i int,\n j int as (i + 1) stored)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            String sql2 = "explain plan for\nselect * from t where j = i + 1";
            String plan = "EnumerableTableScan(table=[[T]])\n";
            try (ResultSet r = s.executeQuery("explain plan for\nselect * from t where j = i + 1");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getString(1), (Matcher)Is.is((Object)"EnumerableTableScan(table=[[T]])\n"));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
        }
    }

    @Test
    public void testVirtualColumn() throws Exception {
        try (Connection c = ServerTest.connect();
             Statement s = c.createStatement();){
            String sql0 = "create table t (\n h int not null,\n i int,\n j int as (i + 1) virtual)";
            boolean b = s.execute("create table t (\n h int not null,\n i int,\n j int as (i + 1) virtual)");
            MatcherAssert.assertThat((Object)b, (Matcher)Is.is((Object)false));
            int x = s.executeUpdate("insert into t (h, i) values (1, 2)");
            MatcherAssert.assertThat((Object)x, (Matcher)Is.is((Object)1));
            String sql = "select * from t";
            try (ResultSet r = s.executeQuery("select * from t");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getInt(1), (Matcher)Is.is((Object)1));
                MatcherAssert.assertThat((Object)r.getInt(2), (Matcher)Is.is((Object)2));
                MatcherAssert.assertThat((Object)r.getInt(3), (Matcher)Is.is((Object)3));
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)false));
            }
            String plan = "EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], proj#0..1=[{exprs}], J=[$t3])\n  EnumerableTableScan(table=[[T]])\n";
            try (ResultSet r = s.executeQuery("explain plan for select * from t");){
                MatcherAssert.assertThat((Object)r.next(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((Object)r.getString(1), (Matcher)Matchers.isLinux((String)"EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], proj#0..1=[{exprs}], J=[$t3])\n  EnumerableTableScan(table=[[T]])\n"));
            }
        }
    }
}

