/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.tpcds;

import com.google.common.base.Function;
import java.util.List;
import java.util.Random;
import net.hydromatic.tpcds.query.Query;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Pair;
import org.junit.Ignore;
import org.junit.Test;

public class TpcdsTest {
    public static final String TPCDS_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'TPCDS',\n   schemas: [\n" + TpcdsTest.schema("TPCDS", "1.0") + ",\n" + TpcdsTest.schema("TPCDS_01", "0.01") + ",\n" + TpcdsTest.schema("TPCDS_5", "5.0") + "\n" + "   ]\n" + "}";

    private static Function<Pair<List<Prepare.Materialization>, Holder<Program>>, Void> handler(final boolean bushy, final int minJoinCount) {
        return new Function<Pair<List<Prepare.Materialization>, Holder<Program>>, Void>(){

            public Void apply(Pair<List<Prepare.Materialization>, Holder<Program>> pair) {
                ((Holder)pair.right).set((Object)Programs.sequence((Program[])new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)bushy, (int)minJoinCount), Programs.CALC_PROGRAM}));
                return null;
            }
        };
    }

    private static String schema(String name, String scaleFactor) {
        return "     {\n       type: 'custom',\n       name: '" + name + "',\n" + "       factory: 'org.apache.calcite.adapter.tpcds.TpcdsSchemaFactory',\n" + "       operand: {\n" + "         columnPrefix: true,\n" + "         scale: " + scaleFactor + "\n" + "       }\n" + "     }";
    }

    private CalciteAssert.AssertThat with() {
        return CalciteAssert.model((String)TPCDS_MODEL).enable(CalciteAssert.ENABLE_SLOW);
    }

    @Test
    public void testCallCenter() {
        this.with().query("select * from tpcds.call_center").returnsUnordered(new String[0]);
    }

    @Ignore(value="add tests like this that count each table")
    @Test
    public void testLineItem() {
        this.with().query("select * from tpcds.lineitem").returnsCount(6001215);
    }

    @Ignore(value="add tests like this that count each table")
    @Test
    public void testCustomer5() {
        this.with().query("select * from tpcds_5.customer").returnsCount(750000);
    }

    @Test
    public void testQuery01() {
        this.checkQuery(1).runs();
    }

    @Test
    public void testQuery17Plan() {
        this.checkQuery(17).withHook(Hook.PROGRAM, TpcdsTest.handler(true, 2)).explainMatches("including all attributes ", CalciteAssert.checkMaskedResultContains((String)"EnumerableCalcRel(expr#0..11=[{inputs}], expr#12=[/($t5, $t4)], expr#13=[/($t8, $t7)], expr#14=[/($t11, $t10)], proj#0..5=[{exprs}], STORE_SALES_QUANTITYCOV=[$t12], AS_STORE_RETURNS_QUANTITYCOUNT=[$t6], AS_STORE_RETURNS_QUANTITYAVE=[$t7], AS_STORE_RETURNS_QUANTITYSTDEV=[$t8], STORE_RETURNS_QUANTITYCOV=[$t13], CATALOG_SALES_QUANTITYCOUNT=[$t9], CATALOG_SALES_QUANTITYAVE=[$t10], CATALOG_SALES_QUANTITYSTDEV=[$t14], CATALOG_SALES_QUANTITYCOV=[$t14]): rowcount = 5.434029018852197E26, cumulative cost = {1.618185849567114E30 rows, 1.2672155671963324E30 cpu, 0.0 io}\n  EnumerableSortRel(sort0=[$0], sort1=[$1], sort2=[$2], dir0=[ASC], dir1=[ASC], dir2=[ASC]): rowcount = 5.434029018852197E26, cumulative cost = {1.6176424466652288E30 rows, 1.2509134801397759E30 cpu, 0.0 io}\n    EnumerableCalcRel(expr#0..12=[{inputs}], expr#13=[/($t4, $t5)], expr#14=[CAST($t13):JavaType(class java.lang.Integer)], expr#15=[*($t4, $t4)], expr#16=[/($t15, $t5)], expr#17=[-($t6, $t16)], expr#18=[1], expr#19=[=($t5, $t18)], expr#20=[null], expr#21=[-($t5, $t18)], expr#22=[CASE($t19, $t20, $t21)], expr#23=[/($t17, $t22)], expr#24=[0.5], expr#25=[POWER($t23, $t24)], expr#26=[CAST($t25):JavaType(class java.lang.Integer)], expr#27=[/($t8, $t7)], expr#28=[CAST($t27):JavaType(class java.lang.Integer)], expr#29=[*($t8, $t8)], expr#30=[/($t29, $t7)], expr#31=[-($t9, $t30)], expr#32=[=($t7, $t18)], expr#33=[-($t7, $t18)], expr#34=[CASE($t32, $t20, $t33)], expr#35=[/($t31, $t34)], expr#36=[POWER($t35, $t24)], expr#37=[CAST($t36):JavaType(class java.lang.Integer)], expr#38=[/($t11, $t10)], expr#39=[CAST($t38):JavaType(class java.lang.Integer)], expr#40=[*($t11, $t11)], expr#41=[/($t40, $t10)], expr#42=[-($t12, $t41)], expr#43=[=($t10, $t18)], expr#44=[-($t10, $t18)], expr#45=[CASE($t43, $t20, $t44)], expr#46=[/($t42, $t45)], expr#47=[POWER($t46, $t24)], expr#48=[CAST($t47):JavaType(class java.lang.Integer)], proj#0..3=[{exprs}], STORE_SALES_QUANTITYAVE=[$t14], STORE_SALES_QUANTITYSTDEV=[$t26], AS_STORE_RETURNS_QUANTITYCOUNT=[$t7], AS_STORE_RETURNS_QUANTITYAVE=[$t28], AS_STORE_RETURNS_QUANTITYSTDEV=[$t37], CATALOG_SALES_QUANTITYCOUNT=[$t10], CATALOG_SALES_QUANTITYAVE=[$t39], $f11=[$t48]): rowcount = 5.434029018852197E26, cumulative cost = {1.1954863841615548E28 rows, 1.2503700772378907E30 cpu, 0.0 io}\n      EnumerableAggregateRel(group=[{0, 1, 2}], STORE_SALES_QUANTITYCOUNT=[COUNT()], agg#1=[SUM($3)], agg#2=[COUNT($3)], agg#3=[SUM($6)], AS_STORE_RETURNS_QUANTITYCOUNT=[COUNT($4)], agg#5=[SUM($4)], agg#6=[SUM($7)], CATALOG_SALES_QUANTITYCOUNT=[COUNT($5)], agg#8=[SUM($5)], agg#9=[SUM($8)]): rowcount = 5.434029018852197E26, cumulative cost = {1.1411460939730328E28 rows, 1.2172225002228922E30 cpu, 0.0 io}\n        EnumerableCalcRel(expr#0..211=[{inputs}], expr#212=[*($t89, $t89)], expr#213=[*($t140, $t140)], expr#214=[*($t196, $t196)], I_ITEM_ID=[$t58], I_ITEM_DESC=[$t61], S_STATE=[$t24], SS_QUANTITY=[$t89], SR_RETURN_QUANTITY=[$t140], CS_QUANTITY=[$t196], $f6=[$t212], $f7=[$t213], $f8=[$t214]): rowcount = 5.434029018852197E27, cumulative cost = {1.0868058037845108E28 rows, 1.2172225002228922E30 cpu, 0.0 io}\n          EnumerableJoinRel(condition=[AND(=($82, $133), =($81, $132), =($88, $139))], joinType=[inner]): rowcount = 5.434029018852197E27, cumulative cost = {5.434029018992911E27 rows, 1.8579845E7 cpu, 0.0 io}\n            EnumerableJoinRel(condition=[=($0, $86)], joinType=[inner]): rowcount = 2.3008402586892598E13, cumulative cost = {4.8588854672853766E13 rows, 7354409.0 cpu, 0.0 io}\n              EnumerableTableAccessRel(table=[[TPCDS, STORE]]): rowcount = 12.0, cumulative cost = {12.0 rows, 13.0 cpu, 0.0 io}\n              EnumerableJoinRel(condition=[=($0, $50)], joinType=[inner]): rowcount = 1.2782445881607E13, cumulative cost = {1.279800620431234E13 rows, 7354396.0 cpu, 0.0 io}\n                EnumerableCalcRel(expr#0..27=[{inputs}], expr#28=[CAST($t15):VARCHAR(6) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], expr#29=['1998Q1'], expr#30=[=($t28, $t29)], proj#0..27=[{exprs}], $condition=[$t30]): rowcount = 10957.35, cumulative cost = {84006.35 rows, 4455990.0 cpu, 0.0 io}\n                  EnumerableTableAccessRel(table=[[TPCDS, DATE_DIM]]): rowcount = 73049.0, cumulative cost = {73049.0 rows, 73050.0 cpu, 0.0 io}\n                EnumerableJoinRel(condition=[=($0, $24)], joinType=[inner]): rowcount = 7.7770908E9, cumulative cost = {7.783045975286664E9 rows, 2898406.0 cpu, 0.0 io}\n                  EnumerableTableAccessRel(table=[[TPCDS, ITEM]]): rowcount = 18000.0, cumulative cost = {18000.0 rows, 18001.0 cpu, 0.0 io}\n                  EnumerableTableAccessRel(table=[[TPCDS, STORE_SALES]]): rowcount = 2880404.0, cumulative cost = {2880404.0 rows, 2880405.0 cpu, 0.0 io}\n            EnumerableJoinRel(condition=[AND(=($31, $79), =($30, $91))], joinType=[inner]): rowcount = 6.9978029381741304E16, cumulative cost = {6.9978054204658736E16 rows, 1.1225436E7 cpu, 0.0 io}\n              EnumerableJoinRel(condition=[=($0, $28)], joinType=[inner]): rowcount = 7.87597881975E8, cumulative cost = {7.884434222216867E8 rows, 5035701.0 cpu, 0.0 io}\n                EnumerableCalcRel(expr#0..27=[{inputs}], expr#28=['1998Q1'], expr#29=[=($t15, $t28)], expr#30=['1998Q2'], expr#31=[=($t15, $t30)], expr#32=['1998Q3'], expr#33=[=($t15, $t32)], expr#34=[OR($t29, $t31, $t33)], proj#0..27=[{exprs}], $condition=[$t34]): rowcount = 18262.25, cumulative cost = {91311.25 rows, 4748186.0 cpu, 0.0 io}\n                  EnumerableTableAccessRel(table=[[TPCDS, DATE_DIM]]): rowcount = 73049.0, cumulative cost = {73049.0 rows, 73050.0 cpu, 0.0 io}\n                EnumerableTableAccessRel(table=[[TPCDS, STORE_RETURNS]]): rowcount = 287514.0, cumulative cost = {287514.0 rows, 287515.0 cpu, 0.0 io}\n              EnumerableJoinRel(condition=[=($0, $28)], joinType=[inner]): rowcount = 3.94888649445E9, cumulative cost = {3.9520401026966867E9 rows, 6189735.0 cpu, 0.0 io}\n                EnumerableCalcRel(expr#0..27=[{inputs}], expr#28=['1998Q1'], expr#29=[=($t15, $t28)], expr#30=['1998Q2'], expr#31=[=($t15, $t30)], expr#32=['1998Q3'], expr#33=[=($t15, $t32)], expr#34=[OR($t29, $t31, $t33)], proj#0..27=[{exprs}], $condition=[$t34]): rowcount = 18262.25, cumulative cost = {91311.25 rows, 4748186.0 cpu, 0.0 io}\n                  EnumerableTableAccessRel(table=[[TPCDS, DATE_DIM]]): rowcount = 73049.0, cumulative cost = {73049.0 rows, 73050.0 cpu, 0.0 io}\n                EnumerableTableAccessRel(table=[[TPCDS, CATALOG_SALES]]): rowcount = 1441548.0, cumulative cost = {1441548.0 rows, 1441549.0 cpu, 0.0 io}\n"));
    }

    @Test
    public void testQuery27() {
        this.checkQuery(27).runs();
    }

    @Test
    public void testQuery58() {
        this.checkQuery(58).explainContains("PLAN").runs();
    }

    @Ignore(value="takes too long to optimize")
    @Test
    public void testQuery72() {
        this.checkQuery(72).runs();
    }

    @Ignore(value="work in progress")
    @Test
    public void testQuery72Plan() {
        this.checkQuery(72).withHook(Hook.PROGRAM, TpcdsTest.handler(true, 2)).planContains("xx");
    }

    @Test
    public void testQuery95() {
        this.checkQuery(95).withHook(Hook.PROGRAM, TpcdsTest.handler(false, 6)).runs();
    }

    private CalciteAssert.AssertQuery checkQuery(int i) {
        Query query = Query.of((int)i);
        String sql = query.sql(new Random(0L));
        switch (i) {
            case 58: {
                if (Bug.upgrade((String)"new TPC-DS generator")) {
                    sql = sql.replace(" = '", " = DATE '");
                    break;
                }
                sql = sql.replace("'date([YEAR]+\"-01-01\",[YEAR]+\"-07-24\",sales)'", "DATE '1998-08-18'");
                break;
            }
            case 72: {
                sql = sql.replace("+ 5", "+ interval '5' day");
                break;
            }
            case 95: {
                sql = sql.replace("60 days", "interval '60' day");
                sql = sql.replace("d_date between '", "d_date between date '");
            }
        }
        return this.with().query(sql.replaceAll("tpcds\\.", "tpcds_01."));
    }

    public Frameworks.ConfigBuilder config() throws Exception {
        final Holder root = Holder.of(null);
        CalciteAssert.model((String)TPCDS_MODEL).doWithConnection((Function)new Function<CalciteConnection, Object>(){

            public Object apply(CalciteConnection input) {
                root.set((Object)input.getRootSchema().getSubSchema("TPCDS"));
                return null;
            }
        });
        return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema((SchemaPlus)root.get()).traitDefs((List)null).programs(new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)true, (int)2)});
    }

    @Test
    public void testQuery27Builder() throws Exception {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)this.config().build());
        RelNode root = builder.scan("STORE_SALES").scan("CUSTOMER_DEMOGRAPHICS").scan("DATE_DIM").scan("STORE").scan("ITEM").join(JoinRelType.INNER, new String[0]).join(JoinRelType.INNER, new String[0]).join(JoinRelType.INNER, new String[0]).join(JoinRelType.INNER, new String[0]).filter(new RexNode[]{builder.equals((RexNode)builder.field("SS_SOLD_DATE_SK"), (RexNode)builder.field("D_DATE_SK")), builder.equals((RexNode)builder.field("SS_ITEM_SK"), (RexNode)builder.field("I_ITEM_SK")), builder.equals((RexNode)builder.field("SS_STORE_SK"), (RexNode)builder.field("S_STORE_SK")), builder.equals((RexNode)builder.field("SS_CDEMO_SK"), (RexNode)builder.field("CD_DEMO_SK")), builder.equals((RexNode)builder.field("CD_GENDER"), builder.literal((Object)"M")), builder.equals((RexNode)builder.field("CD_MARITAL_STATUS"), builder.literal((Object)"S")), builder.equals((RexNode)builder.field("CD_EDUCATION_STATUS"), builder.literal((Object)"HIGH SCHOOL")), builder.equals((RexNode)builder.field("D_YEAR"), builder.literal((Object)1998)), builder.call((SqlOperator)SqlStdOperatorTable.IN, new RexNode[]{builder.field("S_STATE"), builder.call((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, new RexNode[]{builder.literal((Object)"CA"), builder.literal((Object)"OR"), builder.literal((Object)"WA"), builder.literal((Object)"TX"), builder.literal((Object)"OK"), builder.literal((Object)"MD")})})}).aggregate(builder.groupKey(new String[]{"I_ITEM_ID", "S_STATE"}), new RelBuilder.AggCall[]{builder.avg(false, "AGG1", (RexNode)builder.field("SS_QUANTITY")), builder.avg(false, "AGG2", (RexNode)builder.field("SS_LIST_PRICE")), builder.avg(false, "AGG3", (RexNode)builder.field("SS_COUPON_AMT")), builder.avg(false, "AGG4", (RexNode)builder.field("SS_SALES_PRICE"))}).sortLimit(0, 100, new RexNode[]{builder.field("I_ITEM_ID"), builder.field("S_STATE")}).build();
        System.out.println(RelOptUtil.toString((RelNode)root));
    }
}

