/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.chinook;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class CalciteConnectionProvider {
    public static final String DRIVER_URL = "jdbc:calcite:";

    public Connection connection() throws IOException, SQLException {
        return DriverManager.getConnection(DRIVER_URL, this.provideConnectionInfo());
    }

    public Properties provideConnectionInfo() throws IOException {
        Properties info = new Properties();
        info.setProperty("lex", "MYSQL");
        info.setProperty("model", "inline:" + this.provideSchema());
        return info;
    }

    private String provideSchema() throws IOException {
        InputStream stream = this.getClass().getResourceAsStream("/chinook/chinook.json");
        return CharStreams.toString((Readable)new InputStreamReader(stream, Charsets.UTF_8));
    }
}

