/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.chinook;

import java.sql.Connection;
import java.sql.DriverManager;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.chinook.CalciteConnectionProvider;
import org.apache.calcite.chinook.EnvironmentFairy;

public class ConnectionFactory
implements Quidem.ConnectionFactory {
    private static final CalciteConnectionProvider CALCITE = new CalciteConnectionProvider();

    public Connection connect(String db, boolean bln) throws Exception {
        return DBWrapper.valueOf(db).connection();
    }

    private static enum DBWrapper {
        CALCITE_AS_ADMIN{

            @Override
            public Connection connection() throws Exception {
                EnvironmentFairy.login(EnvironmentFairy.User.ADMIN);
                return CALCITE.connection();
            }
        }
        ,
        CALCITE_AS_SPECIFIC_USER{

            @Override
            public Connection connection() throws Exception {
                EnvironmentFairy.login(EnvironmentFairy.User.SPECIFIC_USER);
                return CALCITE.connection();
            }
        }
        ,
        RAW{

            @Override
            public Connection connection() throws Exception {
                return DriverManager.getConnection("jdbc:hsqldb:res:chinook", "sa", "");
            }
        };


        public abstract Connection connection() throws Exception;
    }
}

