/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.os.Processes;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;

public class GitCommitsTableFunction {
    private static final String TS_OFF = "1500769547 -0700";
    private static final String OFF = "-0700";

    private GitCommitsTableFunction() {
    }

    public static ScannableTable eval(boolean b) {
        return new ScannableTable(){

            public Enumerable<Object[]> scan(DataContext root) {
                final Enumerable<String> enumerable = Processes.processLines("git", "log", "--pretty=raw");
                return new AbstractEnumerable<Object[]>(){

                    public Enumerator<Object[]> enumerator() {
                        final Enumerator e = enumerable.enumerator();
                        return new Enumerator<Object[]>(){
                            private Object[] objects;
                            private final StringBuilder b = new StringBuilder();

                            public Object[] current() {
                                if (this.objects == null) {
                                    throw new NoSuchElementException();
                                }
                                return this.objects;
                            }

                            public boolean moveNext() {
                                String line;
                                if (!e.moveNext()) {
                                    this.objects = null;
                                    return false;
                                }
                                this.objects = new Object[9];
                                while ((line = (String)e.current()).length() != 0) {
                                    if (line.startsWith("commit ")) {
                                        this.objects[0] = line.substring("commit ".length());
                                    } else if (line.startsWith("tree ")) {
                                        this.objects[1] = line.substring("tree ".length());
                                    } else if (line.startsWith("parent ")) {
                                        if (this.objects[2] == null) {
                                            this.objects[2] = line.substring("parent ".length());
                                        } else {
                                            this.objects[3] = line.substring("parent ".length());
                                        }
                                    } else if (line.startsWith("author ")) {
                                        this.objects[4] = line.substring("author ".length(), line.length() - GitCommitsTableFunction.TS_OFF.length() - 1);
                                        this.objects[5] = Long.valueOf(line.substring(line.length() - GitCommitsTableFunction.TS_OFF.length(), line.length() - GitCommitsTableFunction.OFF.length() - 1)) * 1000L;
                                    } else if (line.startsWith("committer ")) {
                                        this.objects[6] = line.substring("committer ".length(), line.length() - GitCommitsTableFunction.TS_OFF.length() - 1);
                                        this.objects[7] = Long.valueOf(line.substring(line.length() - GitCommitsTableFunction.TS_OFF.length(), line.length() - GitCommitsTableFunction.OFF.length() - 1)) * 1000L;
                                    }
                                    if (e.moveNext()) continue;
                                    return true;
                                }
                                while (true) {
                                    if (!e.moveNext()) {
                                        this.objects[8] = this.b.toString();
                                        this.b.setLength(0);
                                        return true;
                                    }
                                    line = (String)e.current();
                                    if (line.length() == 0) {
                                        this.objects[8] = this.b.toString();
                                        this.b.setLength(0);
                                        return true;
                                    }
                                    this.b.append(line.substring("    ".length())).append("\n");
                                }
                            }

                            public void reset() {
                                throw new UnsupportedOperationException();
                            }

                            public void close() {
                                e.close();
                            }
                        };
                    }
                };
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("commit", SqlTypeName.CHAR, 40).add("tree", SqlTypeName.CHAR, 40).add("parent", SqlTypeName.CHAR, 40).add("parent2", SqlTypeName.CHAR, 40).add("author", SqlTypeName.VARCHAR).add("author_timestamp", SqlTypeName.TIMESTAMP).add("committer", SqlTypeName.VARCHAR).add("commit_timestamp", SqlTypeName.TIMESTAMP).add("message", SqlTypeName.VARCHAR).build();
            }

            public Statistic getStatistic() {
                return Statistics.of((double)1000.0, (List)ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0})));
            }

            public Schema.TableType getJdbcTableType() {
                return Schema.TableType.TABLE;
            }

            public boolean isRolledUp(String column) {
                return false;
            }

            public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
                return true;
            }
        };
    }
}

