/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.calcite.adapter.os.SqlShell;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class OsAdapterTest {
    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static boolean hasGit() {
        String path = OsAdapterTest.class.getResource("/").getPath();
        File f = new File(path);
        while (f != null && f.exists()) {
            File[] files = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(".git");
                }
            });
            if (files != null && files.length == 1) {
                return true;
            }
            f = f.getParentFile();
        }
        return false;
    }

    @Test
    public void testDu() {
        OsAdapterTest.sql("select * from du").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)r.getInt(1), (Matcher)CoreMatchers.notNullValue());
                    Assert.assertThat((Object)r.getString(2), (Matcher)CoreMatchers.startsWith((String)"./"));
                    Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testDuFilterSortLimit() {
        OsAdapterTest.sql("select * from du where path like '%/src/test/java/%'\norder by 1 limit 2").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)r.getInt(1), (Matcher)CoreMatchers.notNullValue());
                    Assert.assertThat((Object)r.getString(2), (Matcher)CoreMatchers.startsWith((String)"./"));
                    Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testFiles() {
        Assume.assumeFalse((String)"Skip: the 'files' table does not work on Windows", (boolean)OsAdapterTest.isWindows());
        OsAdapterTest.sql("select distinct type from files").returnsUnordered(new String[]{"type=d", "type=f"});
    }

    @Test
    public void testPs() {
        Assume.assumeFalse((String)"Skip: the 'ps' table does not work on Windows", (boolean)OsAdapterTest.isWindows());
        OsAdapterTest.sql("select * from ps").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    StringBuilder b = new StringBuilder();
                    int c = r.getMetaData().getColumnCount();
                    for (int i = 0; i < c; ++i) {
                        b.append(r.getString(i + 1)).append(';');
                        Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    }
                    Assert.assertThat((Object)b.toString(), (Matcher)CoreMatchers.notNullValue());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testPsDistinct() {
        Assume.assumeFalse((String)"Skip: the 'ps' table does not work on Windows", (boolean)OsAdapterTest.isWindows());
        OsAdapterTest.sql("select distinct `user` from ps").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)r.getString(1), (Matcher)CoreMatchers.notNullValue());
                    Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testGitCommits() {
        Assume.assumeTrue((String)"no git", (boolean)OsAdapterTest.hasGit());
        OsAdapterTest.sql("select count(*) from git_commits").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)r.getString(1), (Matcher)CoreMatchers.notNullValue());
                    Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testGitCommitsTop() {
        Assume.assumeTrue((String)"no git", (boolean)OsAdapterTest.hasGit());
        String q = "select author from git_commits\ngroup by 1 order by count(*) desc limit 1";
        OsAdapterTest.sql("select author from git_commits\ngroup by 1 order by count(*) desc limit 1").returnsUnordered(new String[]{"author=Julian Hyde <julianhyde@gmail.com>"});
    }

    @Test
    public void testVmstat() {
        Assume.assumeFalse((String)"Skip: the 'files' table does not work on Windows", (boolean)OsAdapterTest.isWindows());
        OsAdapterTest.sql("select * from vmstat").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet r) {
                try {
                    Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
                    int c = r.getMetaData().getColumnCount();
                    for (int i = 0; i < c; ++i) {
                        Assert.assertThat((Object)r.getLong(i + 1), (Matcher)CoreMatchers.notNullValue());
                        Assert.assertThat((Object)r.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testStdin() throws SQLException {
        try (Hook.Closeable ignore = Hook.STANDARD_STREAMS.addThread((Function)new Function<Holder<Object[]>, Void>(){

            public Void apply(Holder<Object[]> o) {
                Object[] values = (Object[])o.get();
                InputStream in = (InputStream)values[0];
                String s = "First line\nSecond line";
                ByteArrayInputStream in2 = new ByteArrayInputStream("First line\nSecond line".getBytes(StandardCharsets.UTF_8));
                OutputStream out = (OutputStream)values[1];
                OutputStream err = (OutputStream)values[2];
                o.set((Object)new Object[]{in2, out, err});
                return null;
            }
        });){
            Assert.assertThat((Object)this.foo("select count(*) as c from stdin"), (Matcher)CoreMatchers.is((Object)"2\n"));
        }
    }

    @Test
    public void testStdinExplain() {
        String explain = "PLAN=EnumerableAggregate(group=[{}], c=[COUNT()])\n  EnumerableTableFunctionScan(invocation=[stdin(true)], rowType=[RecordType(INTEGER ordinal, VARCHAR line)], elementType=[class [Ljava.lang.Object;])";
        OsAdapterTest.sql("select count(*) as c from stdin").explainContains("PLAN=EnumerableAggregate(group=[{}], c=[COUNT()])\n  EnumerableTableFunctionScan(invocation=[stdin(true)], rowType=[RecordType(INTEGER ordinal, VARCHAR line)], elementType=[class [Ljava.lang.Object;])");
    }

    @Test
    public void testSqlShellFormat() throws SQLException {
        String q = "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)";
        String empty = "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false";
        String spacedOut = "-1 true a   \n2 false b, c\n3 null null\n";
        Assert.assertThat((Object)this.foo("-o", "spaced", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"-1 true a   \n2 false b, c\n3 null null\n"));
        Assert.assertThat((Object)this.foo("-o", "spaced", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false"), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.foo("select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"-1 true a   \n2 false b, c\n3 null null\n"));
        String headersOut = "x y z\n-1 true a   \n2 false b, c\n3 null null\n";
        Assert.assertThat((Object)this.foo("-o", "headers", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"x y z\n-1 true a   \n2 false b, c\n3 null null\n"));
        String headersEmptyOut = "x y z\n";
        Assert.assertThat((Object)this.foo("-o", "headers", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false"), (Matcher)CoreMatchers.is((Object)"x y z\n"));
        String jsonOut = "[\n{\n  \"x\": -1,\n  \"y\": true,\n  \"z\": \"a   \"\n},\n{\n  \"x\": 2,\n  \"y\": false,\n  \"z\": \"b, c\"\n},\n{\n  \"x\": 3,\n  \"y\": null,\n  \"z\": null\n}\n]\n";
        Assert.assertThat((Object)this.foo("-o", "json", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"[\n{\n  \"x\": -1,\n  \"y\": true,\n  \"z\": \"a   \"\n},\n{\n  \"x\": 2,\n  \"y\": false,\n  \"z\": \"b, c\"\n},\n{\n  \"x\": 3,\n  \"y\": null,\n  \"z\": null\n}\n]\n"));
        String jsonEmptyOut = "[\n]\n";
        Assert.assertThat((Object)this.foo("-o", "json", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false"), (Matcher)CoreMatchers.is((Object)"[\n]\n"));
        String csvEmptyOut = "[\n]\n";
        Assert.assertThat((Object)this.foo("-o", "json", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false"), (Matcher)CoreMatchers.is((Object)"[\n]\n"));
        String csvOut = "x,y,z\n-1,true,a   \n2,false,\"b, c\"\n3,,";
        Assert.assertThat((Object)this.foo("-o", "csv", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"x,y,z\n-1,true,a   \n2,false,\"b, c\"\n3,,"));
        String mysqlOut = "+----+-------+------+\n|  x | y     | z    |\n+----+-------+------+\n| -1 | true  | a    |\n|  2 | false | b, c |\n|  3 |       |      |\n+----+-------+------+\n(3 rows)\n\n";
        Assert.assertThat((Object)this.foo("-o", "mysql", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z)"), (Matcher)CoreMatchers.is((Object)"+----+-------+------+\n|  x | y     | z    |\n+----+-------+------+\n| -1 | true  | a    |\n|  2 | false | b, c |\n|  3 |       |      |\n+----+-------+------+\n(3 rows)\n\n"));
        String mysqlEmptyOut = "+---+---+---+\n| x | y | z |\n+---+---+---+\n+---+---+---+\n(0 rows)\n\n";
        Assert.assertThat((Object)this.foo("-o", "mysql", "select * from (values (-1, true, 'a'), (2, false, 'b, c'), (3, unknown, cast(null as char(1)))) as t(x, y, z) where false"), (Matcher)CoreMatchers.is((Object)"+---+---+---+\n| x | y | z |\n+---+---+---+\n+---+---+---+\n(0 rows)\n\n"));
    }

    private String foo(String ... args) throws SQLException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[0]);
        InputStreamReader in = new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8);
        StringWriter outSw = new StringWriter();
        PrintWriter out = new PrintWriter(outSw);
        StringWriter errSw = new StringWriter();
        PrintWriter err = new PrintWriter(errSw);
        new SqlShell(in, out, err, args).run();
        return Util.toLinux((String)outSw.toString());
    }

    @Test
    public void testSqlShellHelp() throws SQLException {
        String help = "Usage: sqlsh [OPTION]... SQL\nExecute a SQL command\n\nOptions:\n  -o FORMAT  Print output in FORMAT; options are 'spaced' (the default), 'csv',\n             'headers', 'json', 'mysql'\n  -h --help  Print this help\n";
        String q = "select 1";
        Assert.assertThat((Object)this.foo("--help", "select 1"), (Matcher)CoreMatchers.is((Object)"Usage: sqlsh [OPTION]... SQL\nExecute a SQL command\n\nOptions:\n  -o FORMAT  Print output in FORMAT; options are 'spaced' (the default), 'csv',\n             'headers', 'json', 'mysql'\n  -h --help  Print this help\n"));
        Assert.assertThat((Object)this.foo("-h", "select 1"), (Matcher)CoreMatchers.is((Object)"Usage: sqlsh [OPTION]... SQL\nExecute a SQL command\n\nOptions:\n  -o FORMAT  Print output in FORMAT; options are 'spaced' (the default), 'csv',\n             'headers', 'json', 'mysql'\n  -h --help  Print this help\n"));
        try {
            String s = this.foo("-o", "bad", "select 1");
            Assert.fail((String)("expected exception, got " + s));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown format: bad"));
        }
    }

    static CalciteAssert.AssertQuery sql(String sql) {
        return CalciteAssert.that().withModel(SqlShell.MODEL).with(CalciteConnectionProperty.LEX.camelName(), (Object)Lex.JAVA).with(CalciteConnectionProperty.CONFORMANCE.camelName(), (Object)SqlConformanceEnum.LENIENT).query(sql);
    }
}

