/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;

public class PigFilter
extends Filter
implements PigRel {
    public PigFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
        super(cluster, traitSet, input, condition);
        assert (this.getConvention() == PigRel.CONVENTION);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new PigFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(PigRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        implementor.addStatement(this.getPigFilterStatement(implementor));
    }

    public RelOptTable getTable() {
        return this.getInput().getTable();
    }

    private String getPigFilterStatement(PigRel.Implementor implementor) {
        Preconditions.checkState((boolean)this.containsOnlyConjunctions(this.condition));
        String relationAlias = implementor.getPigRelationAlias(this);
        ArrayList<String> filterConditionsConjunction = new ArrayList<String>();
        for (RexNode node : RelOptUtil.conjunctions((RexNode)this.condition)) {
            filterConditionsConjunction.add(this.getSingleFilterCondition(implementor, node));
        }
        String allFilterConditions = String.join((CharSequence)" AND ", filterConditionsConjunction);
        return relationAlias + " = FILTER " + relationAlias + " BY " + allFilterConditions + ';';
    }

    private String getSingleFilterCondition(PigRel.Implementor implementor, RexNode node) {
        switch (node.getKind()) {
            case EQUALS: {
                return this.getSingleFilterCondition(implementor, "==", (RexCall)node);
            }
            case LESS_THAN: {
                return this.getSingleFilterCondition(implementor, "<", (RexCall)node);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.getSingleFilterCondition(implementor, "<=", (RexCall)node);
            }
            case GREATER_THAN: {
                return this.getSingleFilterCondition(implementor, ">", (RexCall)node);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.getSingleFilterCondition(implementor, ">=", (RexCall)node);
            }
        }
        throw new IllegalArgumentException("Cannot translate node " + node);
    }

    private String getSingleFilterCondition(PigRel.Implementor implementor, String op, RexCall call) {
        String literal;
        String fieldName;
        RexNode left = (RexNode)call.operands.get(0);
        RexNode right = (RexNode)call.operands.get(1);
        if (left.getKind() == SqlKind.LITERAL) {
            if (right.getKind() != SqlKind.INPUT_REF) {
                throw new IllegalArgumentException("Expected a RexCall with a single field and single literal");
            }
            fieldName = implementor.getFieldName(this, ((RexInputRef)right).getIndex());
            literal = this.getLiteralAsString((RexLiteral)left);
        } else if (right.getKind() == SqlKind.LITERAL) {
            if (left.getKind() != SqlKind.INPUT_REF) {
                throw new IllegalArgumentException("Expected a RexCall with a single field and single literal");
            }
            fieldName = implementor.getFieldName(this, ((RexInputRef)left).getIndex());
            literal = this.getLiteralAsString((RexLiteral)right);
        } else {
            throw new IllegalArgumentException("Expected a RexCall with a single field and single literal");
        }
        return '(' + fieldName + ' ' + op + ' ' + literal + ')';
    }

    private boolean containsOnlyConjunctions(RexNode condition) {
        return RelOptUtil.disjunctions((RexNode)condition).size() == 1;
    }

    private String getLiteralAsString(RexLiteral literal) {
        return '\'' + RexLiteral.stringValue((RexNode)literal) + '\'';
    }
}

