/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.pig.PigAggFunction;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;

public class PigAggregate
extends Aggregate
implements PigRel {
    public static final String DISTINCT_FIELD_SUFFIX = "_DISTINCT";

    public PigAggregate(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traits, child, indicator, groupSet, groupSets, aggCalls);
        assert (this.getConvention() == PigRel.CONVENTION);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new PigAggregate(input.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public void implement(PigRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        implementor.addStatement(this.getPigAggregateStatement(implementor));
    }

    private String getPigAggregateStatement(PigRel.Implementor implementor) {
        return this.getPigGroupBy(implementor) + '\n' + this.getPigForEachGenerate(implementor);
    }

    public RelOptTable getTable() {
        return this.getInput().getTable();
    }

    private String getPigGroupBy(PigRel.Implementor implementor) {
        String relAlias = implementor.getPigRelationAlias(this);
        List allFields = this.getInput().getRowType().getFieldList();
        List groupedFieldIndexes = this.groupSet.asList();
        if (groupedFieldIndexes.size() < 1) {
            return relAlias + " = GROUP " + relAlias + " ALL;";
        }
        ArrayList<String> groupedFieldNames = new ArrayList<String>(groupedFieldIndexes.size());
        Iterator iterator = groupedFieldIndexes.iterator();
        while (iterator.hasNext()) {
            int fieldIndex = (Integer)iterator.next();
            groupedFieldNames.add(((RelDataTypeField)allFields.get(fieldIndex)).getName());
        }
        return relAlias + " = GROUP " + relAlias + " BY (" + String.join((CharSequence)", ", groupedFieldNames) + ");";
    }

    private String getPigForEachGenerate(PigRel.Implementor implementor) {
        String relAlias = implementor.getPigRelationAlias(this);
        String generateCall = this.getPigGenerateCall(implementor);
        List<String> distinctCalls = this.getDistinctCalls(implementor);
        return relAlias + " = FOREACH " + relAlias + " {\n" + String.join((CharSequence)";\n", distinctCalls) + generateCall + "\n};";
    }

    private String getPigGenerateCall(PigRel.Implementor implementor) {
        List groupedFieldIndexes = this.groupSet.asList();
        HashSet<String> groupFields = new HashSet<String>(groupedFieldIndexes.size());
        Iterator iterator = groupedFieldIndexes.iterator();
        while (iterator.hasNext()) {
            int fieldIndex = (Integer)iterator.next();
            String fieldName = this.getInputFieldName(fieldIndex);
            String groupField = (groupedFieldIndexes.size() == 1 ? "group" : "group." + fieldName) + " AS " + fieldName;
            groupFields.add(groupField);
        }
        List<String> pigAggCalls = this.getPigAggregateCalls(implementor);
        ArrayList<String> allFields = new ArrayList<String>(groupFields.size() + pigAggCalls.size());
        allFields.addAll(groupFields);
        allFields.addAll(pigAggCalls);
        return "  GENERATE " + String.join((CharSequence)", ", allFields) + ';';
    }

    private List<String> getPigAggregateCalls(PigRel.Implementor implementor) {
        String relAlias = implementor.getPigRelationAlias(this);
        ArrayList<String> result = new ArrayList<String>(this.aggCalls.size());
        for (AggregateCall ac : this.aggCalls) {
            result.add(this.getPigAggregateCall(relAlias, ac));
        }
        return result;
    }

    private String getPigAggregateCall(String relAlias, AggregateCall aggCall) {
        PigAggFunction aggFunc = this.toPigAggFunc(aggCall);
        String alias = aggCall.getName();
        String fields = String.join((CharSequence)", ", this.getArgNames(relAlias, aggCall));
        return aggFunc.name() + "(" + fields + ") AS " + alias;
    }

    private PigAggFunction toPigAggFunc(AggregateCall aggCall) {
        return PigAggFunction.valueOf(aggCall.getAggregation().getKind(), aggCall.getArgList().size() < 1);
    }

    private List<String> getArgNames(String relAlias, AggregateCall aggCall) {
        ArrayList<String> result = new ArrayList<String>(aggCall.getArgList().size());
        Iterator iterator = aggCall.getArgList().iterator();
        while (iterator.hasNext()) {
            int fieldIndex = (Integer)iterator.next();
            result.add(this.getInputFieldNameForAggCall(relAlias, aggCall, fieldIndex));
        }
        return result;
    }

    private String getInputFieldNameForAggCall(String relAlias, AggregateCall aggCall, int fieldIndex) {
        String inputField = this.getInputFieldName(fieldIndex);
        return aggCall.isDistinct() ? inputField + DISTINCT_FIELD_SUFFIX : relAlias + '.' + inputField;
    }

    private List<String> getDistinctCalls(PigRel.Implementor implementor) {
        String relAlias = implementor.getPigRelationAlias(this);
        ArrayList<String> result = new ArrayList<String>();
        for (AggregateCall aggCall : this.aggCalls) {
            if (!aggCall.isDistinct()) continue;
            Iterator iterator = aggCall.getArgList().iterator();
            while (iterator.hasNext()) {
                int fieldIndex = (Integer)iterator.next();
                String fieldName = this.getInputFieldName(fieldIndex);
                result.add("  " + fieldName + DISTINCT_FIELD_SUFFIX + " = DISTINCT " + relAlias + '.' + fieldName + ";\n");
            }
        }
        return result;
    }

    private String getInputFieldName(int fieldIndex) {
        return ((RelDataTypeField)this.getInput().getRowType().getFieldList().get(fieldIndex)).getName();
    }
}

