/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import org.apache.calcite.test.AbstractPigTest;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Sources;
import org.junit.Assert;
import org.junit.Test;

public class PigAdapterTest
extends AbstractPigTest {
    public static final ImmutableMap<String, String> MODEL = ImmutableMap.of((Object)"model", (Object)Sources.of((URL)PigAdapterTest.class.getResource("/model.json")).file().getAbsolutePath());

    @Test
    public void testScanAndFilter() throws Exception {
        CalciteAssert.that().with(MODEL).query("select * from \"t\" where \"tc0\" > 'abc'").explainContains("PigToEnumerableConverter\n  PigFilter(condition=[>($0, 'abc')])\n    PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'abc');"));
    }

    @Test
    public void testImplWithMultipleFilters() {
        CalciteAssert.that().with(MODEL).query("select * from \"t\" where \"tc0\" > 'abc' and \"tc1\" = '3'").explainContains("PigToEnumerableConverter\n  PigFilter(condition=[AND(>($0, 'abc'), =($1, '3'))])\n    PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'abc') AND (tc1 == '3');"));
    }

    @Test
    public void testImplWithGroupByAndCount() {
        CalciteAssert.that().with(MODEL).query("select count(\"tc1\") c from \"t\" group by \"tc0\"").explainContains("PigToEnumerableConverter\n    PigAggregate(group=[{0}], C=[COUNT($1)])\n      PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc0);\nt = FOREACH t {\n  GENERATE group AS tc0, COUNT(t.tc1) AS C;\n};"));
    }

    @Test
    public void testImplWithCountWithoutGroupBy() {
        CalciteAssert.that().with(MODEL).query("select count(\"tc0\") c from \"t\"").explainContains("PigToEnumerableConverter\n  PigAggregate(group=[{}], C=[COUNT($0)])\n    PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t ALL;\nt = FOREACH t {\n  GENERATE COUNT(t.tc0) AS C;\n};"));
    }

    @Test
    public void testImplWithGroupByMultipleFields() {
        CalciteAssert.that().with(MODEL).query("select * from \"t\" group by \"tc1\", \"tc0\"").explainContains("PigToEnumerableConverter\n  PigAggregate(group=[{0, 1}])\n    PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc0, tc1);\nt = FOREACH t {\n  GENERATE group.tc0 AS tc0, group.tc1 AS tc1;\n};"));
    }

    @Test
    public void testImplWithGroupByCountDistinct() {
        CalciteAssert.that().with(MODEL).query("select count(distinct \"tc0\") c from \"t\" group by \"tc1\"").explainContains("PigToEnumerableConverter\n    PigAggregate(group=[{1}], C=[COUNT(DISTINCT $0)])\n      PigTableScan(table=[[PIG, t]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc1);\nt = FOREACH t {\n  tc0_DISTINCT = DISTINCT t.tc0;\n  GENERATE group AS tc1, COUNT(tc0_DISTINCT) AS C;\n};"));
    }

    @Test
    public void testImplWithJoin() throws Exception {
        CalciteAssert.that().with(MODEL).query("select * from \"t\" join \"s\" on \"tc1\"=\"sc0\"").explainContains("PigToEnumerableConverter\n  PigJoin(condition=[=($1, $2)], joinType=[inner])\n    PigTableScan(table=[[PIG, t]])\n    PigTableScan(table=[[PIG, s]])").runs().queryContains(PigAdapterTest.pigScriptChecker("t = LOAD '" + this.getFullPathForTestDataFile("data.txt") + "' USING PigStorage() AS (tc0:chararray, tc1:chararray);\ns = LOAD '" + this.getFullPathForTestDataFile("data2.txt") + "' USING PigStorage() AS (sc0:chararray, sc1:chararray);\nt = JOIN t BY tc1 , s BY sc0;"));
    }

    private static Consumer<List> pigScriptChecker(String ... strings) {
        return actual -> {
            String actualArray = actual == null || actual.isEmpty() ? null : (String)actual.get(0);
            Assert.assertEquals((String)"expected Pig script not found", (Object)strings[0], (Object)actualArray);
        };
    }
}

