/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;

public interface PigRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("PIG", PigRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        private final List<String> statements = new ArrayList<String>();

        public String getTableName(RelNode input) {
            List qualifiedName = input.getTable().getQualifiedName();
            return (String)qualifiedName.get(qualifiedName.size() - 1);
        }

        public String getPigRelationAlias(RelNode input) {
            return this.getTableName(input);
        }

        public String getFieldName(RelNode input, int index) {
            return ((RelDataTypeField)input.getRowType().getFieldList().get(index)).getName();
        }

        public void addStatement(String statement) {
            this.statements.add(statement);
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((PigRel)input).implement(this);
        }

        public List<String> getStatements() {
            return this.statements;
        }

        public String getScript() {
            return Joiner.on((String)"\n").join(this.statements);
        }
    }
}

