/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.adapter.pig.PigAggregate;
import org.apache.calcite.adapter.pig.PigFilter;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigRelFactories;
import org.apache.calcite.adapter.pig.PigRules;
import org.apache.calcite.adapter.pig.PigTable;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.AbstractPigTest;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.pigunit.Cluster;
import org.apache.pig.pigunit.PigTest;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PigRelBuilderStyleTest
extends AbstractPigTest {
    @Test
    public void testScanAndFilter() throws Exception {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("tc0"), builder.literal((Object)"abc")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'abc');", new String[]{"(b,2)", "(c,3)"});
    }

    @Test
    public void testImplWithMultipleFilters() {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).filter(new RexNode[]{builder.and(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("tc0"), builder.literal((Object)"abc")}), builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("tc1"), builder.literal((Object)"3")})})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'abc') AND (tc1 == '3');", new String[]{"(c,3)"});
    }

    @Test
    public void testImplWithGroupByAndCount() {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).aggregate(builder.groupKey(new String[]{"tc0"}), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field("tc1")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc0);\nt = FOREACH t {\n  GENERATE group AS tc0, COUNT(t.tc1) AS c;\n};", new String[]{"(a,1)", "(b,1)", "(c,1)"});
    }

    @Test
    public void testImplWithCountWithoutGroupBy() {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field("tc0")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t ALL;\nt = FOREACH t {\n  GENERATE COUNT(t.tc0) AS c;\n};", new String[]{"(3)"});
    }

    @Test
    public void testImplWithGroupByMultipleFields() {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).aggregate(builder.groupKey(new String[]{"tc1", "tc0"}), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field("tc1")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc0, tc1);\nt = FOREACH t {\n  GENERATE group.tc0 AS tc0, group.tc1 AS tc1, COUNT(t.tc1) AS c;\n};", new String[]{"(a,1,1)", "(b,2,1)", "(c,3,1)"});
    }

    @Test
    public void testImplWithGroupByCountDistinct() {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).aggregate(builder.groupKey(new String[]{"tc1", "tc0"}), new RelBuilder.AggCall[]{builder.count(true, "c", new RexNode[]{builder.field("tc1")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = GROUP t BY (tc0, tc1);\nt = FOREACH t {\n  tc1_DISTINCT = DISTINCT t.tc1;\n  GENERATE group.tc0 AS tc0, group.tc1 AS tc1, COUNT(tc1_DISTINCT) AS c;\n};", new String[]{"(a,1,1)", "(b,2,1)", "(c,3,1)"});
    }

    @Test
    public void testImplWithJoin() throws Exception {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).scan(new String[]{"s"}).join(JoinRelType.INNER, builder.equals((RexNode)builder.field(2, 0, "tc1"), (RexNode)builder.field(2, 1, "sc0"))).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("tc0"), builder.literal((Object)"a")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'a');\ns = LOAD 'data2.txt' USING PigStorage() AS (sc0:chararray, sc1:chararray);\nt = JOIN t BY tc1 , s BY sc0;", new String[]{"(b,2,2,label2)"});
    }

    @Test
    public void testImplWithJoinAndGroupBy() throws Exception {
        SchemaPlus schema = this.createTestSchema();
        RelBuilder builder = this.createRelBuilder(schema);
        RelNode node = builder.scan(new String[]{"t"}).scan(new String[]{"s"}).join(JoinRelType.LEFT, builder.equals((RexNode)builder.field(2, 0, "tc1"), (RexNode)builder.field(2, 1, "sc0"))).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("tc0"), builder.literal((Object)"abc")})}).aggregate(builder.groupKey(new String[]{"tc1"}), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field("sc1")})}).build();
        RelNode optimized = this.optimizeWithVolcano(node);
        this.assertScriptAndResults("t", this.getPigScript(optimized, (Schema)schema), "t = LOAD 'data.txt' USING PigStorage() AS (tc0:chararray, tc1:chararray);\nt = FILTER t BY (tc0 > 'abc');\ns = LOAD 'data2.txt' USING PigStorage() AS (sc0:chararray, sc1:chararray);\nt = JOIN t BY tc1 LEFT, s BY sc0;\nt = GROUP t BY (tc1);\nt = FOREACH t {\n  GENERATE group AS tc1, COUNT(t.sc1) AS c;\n};", new String[]{"(2,1)", "(3,0)"});
    }

    private SchemaPlus createTestSchema() {
        SchemaPlus result = Frameworks.createRootSchema((boolean)false);
        result.add("t", (Table)new PigTable("data.txt", new String[]{"tc0", "tc1"}));
        result.add("s", (Table)new PigTable("data2.txt", new String[]{"sc0", "sc1"}));
        return result;
    }

    private RelBuilder createRelBuilder(SchemaPlus schema) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(schema).context(PigRelFactories.ALL_PIG_REL_FACTORIES).build();
        return RelBuilder.create((FrameworkConfig)config);
    }

    private RelNode optimizeWithVolcano(RelNode root) {
        RelOptPlanner planner = this.getVolcanoPlanner(root);
        return planner.findBestExp();
    }

    private RelOptPlanner getVolcanoPlanner(RelNode root) {
        RelBuilderFactory builderFactory = RelBuilder.proto((Context)PigRelFactories.ALL_PIG_REL_FACTORIES);
        RelOptPlanner planner = root.getCluster().getPlanner();
        for (RelOptRule r : PigRules.ALL_PIG_OPT_RULES) {
            planner.addRule(r);
        }
        planner.removeRule((RelOptRule)FilterAggregateTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)FilterJoinRule.FILTER_ON_JOIN);
        planner.addRule((RelOptRule)new FilterAggregateTransposeRule(PigFilter.class, builderFactory, PigAggregate.class));
        planner.addRule((RelOptRule)new FilterJoinRule.FilterIntoJoinRule(true, builderFactory, FilterJoinRule.TRUE_PREDICATE));
        planner.setRoot(root);
        return planner;
    }

    private void assertScriptAndResults(String relAliasForStore, String script, String expectedScript, String[] expectedResults) {
        try {
            Assert.assertEquals((Object)expectedScript, (Object)script);
            script = script + "\nSTORE " + relAliasForStore + " INTO 'myoutput';";
            PigTest pigTest = new PigTest(script.split("[\\r\\n]+"));
            pigTest.assertOutputAnyOrder(expectedResults);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPigScript(RelNode root, Schema schema) {
        PigRel.Implementor impl = new PigRel.Implementor();
        impl.visitChild(0, root);
        return impl.getScript();
    }

    @After
    public void shutdownPigServer() {
        PigTest.getPigServer().shutdown();
    }

    @Before
    public void setupDataFilesForPigServer() throws Exception {
        System.getProperties().setProperty("pigunit.exectype", Util.getLocalTestMode().toString());
        Cluster cluster = PigTest.getCluster();
        cluster.update(new Path(this.getFullPathForTestDataFile("data.txt")), new Path("data.txt"));
        cluster.update(new Path(this.getFullPathForTestDataFile("data2.txt")), new Path("data2.txt"));
    }
}

