/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import java.util.List;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.adapter.mongodb.MongoToEnumerableConverterRule;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTableScan
extends TableScan
implements MongoRel {
    final MongoTable mongoTable;
    final RelDataType projectRowType;

    protected MongoTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MongoTable mongoTable, RelDataType projectRowType) {
        super(cluster, traitSet, table);
        this.mongoTable = mongoTable;
        this.projectRowType = projectRowType;
        assert (mongoTable != null);
        assert (this.getConvention() == MongoRel.CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner).multiplyBy(0.1 * (double)f);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)MongoToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : MongoRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.mongoTable = this.mongoTable;
        implementor.table = this.table;
    }
}

