/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.mongodb.MongoEnumerator;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoSchema;
import org.apache.calcite.adapter.mongodb.MongoTableScan;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTable
extends AbstractQueryableTable
implements TranslatableTable {
    protected final String collectionName;

    MongoTable(String collectionName) {
        super(Object[].class);
        this.collectionName = collectionName;
    }

    public String toString() {
        return "MongoTable {" + this.collectionName + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType mapType = typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.ANY));
        return typeFactory.builder().add("_MAP", mapType).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new MongoQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new MongoTableScan(cluster, cluster.traitSetOf(new RelTrait[]{MongoRel.CONVENTION}), relOptTable, this, null);
    }

    public Enumerable<Object> find(DB mongoDb, String filterJson, String projectJson, List<Map.Entry<String, Class>> fields) {
        final DBCollection collection = mongoDb.getCollection(this.collectionName);
        final DBObject filter = filterJson == null ? null : (DBObject)JSON.parse((String)filterJson);
        final DBObject project = projectJson == null ? null : (DBObject)JSON.parse((String)projectJson);
        final Function1<DBObject, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                DBCursor cursor = collection.find(filter, project);
                return new MongoEnumerator((Iterator<DBObject>)cursor, (Function1<DBObject, Object>)getter);
            }
        };
    }

    public Enumerable<Object> aggregate(final DB mongoDb, List<Map.Entry<String, Class>> fields, final List<String> operations) {
        final ArrayList<DBObject> list = new ArrayList<DBObject>();
        BasicDBList versionArray = (BasicDBList)mongoDb.command("buildInfo").get("versionArray");
        final Integer versionMajor = MongoTable.parseIntString(versionArray.get(0).toString());
        final Integer versionMinor = MongoTable.parseIntString(versionArray.get(1).toString());
        for (String operation : operations) {
            list.add((DBObject)JSON.parse((String)operation));
        }
        final DBObject first = (DBObject)list.get(0);
        final List rest = Util.skip(list);
        final Function1<DBObject, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                Iterator<Object> resultIterator;
                try {
                    if (versionMajor > 1) {
                        if (versionMinor > 5) {
                            AggregationOptions options = AggregationOptions.builder().outputMode(AggregationOptions.OutputMode.CURSOR).build();
                            ArrayList resultAsArrayList = new ArrayList(Util.toList((Iterator)mongoDb.getCollection(MongoTable.this.collectionName).aggregate(list, options)));
                            resultIterator = resultAsArrayList.iterator();
                        } else {
                            AggregationOutput result = MongoTable.this.aggregateOldWay(mongoDb.getCollection(MongoTable.this.collectionName), first, rest);
                            resultIterator = result.results().iterator();
                        }
                    } else {
                        AggregationOutput result = MongoTable.this.aggregateOldWay(mongoDb.getCollection(MongoTable.this.collectionName), first, rest);
                        resultIterator = result.results().iterator();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("While running MongoDB query " + Util.toString((Iterable)operations, (String)"[", (String)",\n", (String)"]"), e);
                }
                return new MongoEnumerator(resultIterator, (Function1<DBObject, Object>)getter);
            }
        };
    }

    private static Integer parseIntString(String valueString) {
        return Integer.parseInt(valueString.replaceAll("[^0-9]", ""));
    }

    private AggregationOutput aggregateOldWay(DBCollection dbCollection, DBObject first, List<DBObject> rest) {
        return dbCollection.aggregate(first, rest.toArray(new DBObject[rest.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoQueryable<T>
    extends AbstractTableQueryable<T> {
        public MongoQueryable(QueryProvider queryProvider, SchemaPlus schema, MongoTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable<Object> enumerable = this.getTable().find(this.getMongoDb(), null, null, null);
            return enumerable.enumerator();
        }

        private DB getMongoDb() {
            return ((MongoSchema)((Object)this.schema.unwrap(MongoSchema.class))).mongoDb;
        }

        private MongoTable getTable() {
            return (MongoTable)this.table;
        }

        public Enumerable<Object> aggregate(List<Map.Entry<String, Class>> fields, List<String> operations) {
            return this.getTable().aggregate(this.getMongoDb(), fields, operations);
        }

        public Enumerable<Object> find(String filterJson, String projectJson, List<Map.Entry<String, Class>> fields) {
            return this.getTable().find(this.getMongoDb(), filterJson, projectJson, fields);
        }
    }
}

