/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.collect.ImmutableMap;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import java.util.Map;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoSchema
extends AbstractSchema {
    final DB mongoDb;

    public MongoSchema(String host, String database) {
        try {
            MongoClient mongo = new MongoClient(host);
            this.mongoDb = mongo.getDB(database);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String collectionName : this.mongoDb.getCollectionNames()) {
            builder.put((Object)collectionName, (Object)new MongoTable(collectionName));
        }
        return builder.build();
    }
}

