/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoEnumerator
implements Enumerator<Object> {
    private final Iterator<DBObject> cursor;
    private final Function1<DBObject, Object> getter;
    private Object current;

    public MongoEnumerator(Iterator<DBObject> cursor, Function1<DBObject, Object> getter) {
        this.cursor = cursor;
        this.getter = getter;
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.cursor.hasNext()) {
                DBObject map = this.cursor.next();
                this.current = this.getter.apply((Object)map);
                return true;
            }
            this.current = null;
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.cursor instanceof DBCursor) {
            ((DBCursor)this.cursor).close();
        }
    }

    static Function1<DBObject, Map> mapGetter() {
        return new Function1<DBObject, Map>(){

            public Map apply(DBObject a0) {
                return (Map)a0;
            }
        };
    }

    static Function1<DBObject, Object> singletonGetter(final String fieldName, final Class fieldClass) {
        return new Function1<DBObject, Object>(){

            public Object apply(DBObject a0) {
                return MongoEnumerator.convert(a0.get(fieldName), fieldClass);
            }
        };
    }

    static Function1<DBObject, Object[]> listGetter(final List<Map.Entry<String, Class>> fields) {
        return new Function1<DBObject, Object[]>(){

            public Object[] apply(DBObject a0) {
                Object[] objects = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Map.Entry field = (Map.Entry)fields.get(i);
                    String name = (String)field.getKey();
                    objects[i] = MongoEnumerator.convert(a0.get(name), (Class)field.getValue());
                }
                return objects;
            }
        };
    }

    static Function1<DBObject, Object> getter(List<Map.Entry<String, Class>> fields) {
        return fields == null ? MongoEnumerator.mapGetter() : (fields.size() == 1 ? MongoEnumerator.singletonGetter(fields.get(0).getKey(), fields.get(0).getValue()) : MongoEnumerator.listGetter(fields));
    }

    private static Object convert(Object o, Class clazz) {
        if (o == null || clazz.isInstance(o)) {
            return o;
        }
        if ((clazz == Integer.TYPE || clazz == Integer.class) && o instanceof Date) {
            return (int)(((Date)o).getTime() / 86400000L);
        }
        return o;
    }
}

