/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.adapter.file.FileReaderException;
import org.apache.calcite.util.Source;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FileReader
implements Iterable<Elements> {
    private final Source source;
    private final String selector;
    private final Integer index;
    private final Charset charset = StandardCharsets.UTF_8;
    private Element tableElement;
    private Elements headings;

    public FileReader(Source source, String selector, Integer index) throws FileReaderException {
        if (source == null) {
            throw new FileReaderException("source must not be null");
        }
        this.source = source;
        this.selector = selector;
        this.index = index;
    }

    public FileReader(Source source, String selector) throws FileReaderException {
        this(source, selector, null);
    }

    public FileReader(Source source) throws FileReaderException {
        this(source, null, null);
    }

    private void getTable() throws FileReaderException {
        Document doc;
        try {
            String proto = this.source.protocol();
            doc = "file".equals(proto) ? Jsoup.parse((File)this.source.file(), (String)this.charset.name()) : (Arrays.asList("http", "https", "ftp").contains(proto) ? Jsoup.parse((URL)this.source.url(), (int)((int)TimeUnit.SECONDS.toMillis(20L))) : Jsoup.parse((InputStream)this.source.openStream(), (String)this.charset.name(), (String)""));
        }
        catch (IOException e) {
            throw new FileReaderException("Cannot read " + this.source, e);
        }
        this.tableElement = this.selector != null && !this.selector.equals("") ? this.getSelectedTable(doc, this.selector) : this.getBestTable(doc);
    }

    private Element getSelectedTable(Document doc, String selector) throws FileReaderException {
        Element el;
        Elements list = doc.select(selector);
        if (this.index == null) {
            if (list.size() != 1) {
                throw new FileReaderException("" + list.size() + " HTML element(s) selected");
            }
            el = list.first();
        } else {
            el = (Element)list.get(this.index.intValue());
        }
        if (el.tag().getName().equals("table")) {
            return el;
        }
        throw new FileReaderException("selected (" + selector + ") element is a " + el.tag().getName() + ", not a table");
    }

    private Element getBestTable(Document doc) throws FileReaderException {
        Element bestTable = null;
        int bestScore = -1;
        for (Element t : doc.select("table")) {
            Element firstRow;
            int cols;
            int rows = t.select("tr").size();
            int thisScore = rows * (cols = (firstRow = (Element)t.select("tr").get(0)).select("th,td").size());
            if (thisScore <= bestScore) continue;
            bestTable = t;
            bestScore = thisScore;
        }
        if (bestTable == null) {
            throw new FileReaderException("no tables found");
        }
        return bestTable;
    }

    void refresh() throws FileReaderException {
        this.headings = null;
        this.getTable();
    }

    Elements getHeadings() throws FileReaderException {
        if (this.headings == null) {
            this.iterator();
        }
        return this.headings;
    }

    private String tableKey() {
        return "Table: {url: " + this.source + ", selector: " + this.selector + "}";
    }

    public FileReaderIterator iterator() {
        FileReaderIterator iterator;
        Elements headings;
        if (this.tableElement == null) {
            try {
                this.getTable();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((headings = (iterator = new FileReaderIterator(this.tableElement.select("tr"))).next("th")).size() == 0) {
            iterator = new FileReaderIterator(this.tableElement.select("tr"));
            Elements firstRow = iterator.next("td");
            int i = 0;
            headings = new Elements();
            for (Element td : firstRow) {
                Element th = td.clone();
                th.tagName("th");
                th.html("col" + i++);
                headings.add((Object)th);
            }
            iterator = new FileReaderIterator(this.tableElement.select("tr"));
        }
        this.headings = headings;
        return iterator;
    }

    public void close() {
    }

    private static class FileReaderIterator
    implements Iterator<Elements> {
        final Iterator<Element> rowIterator;

        FileReaderIterator(Elements rows) {
            this.rowIterator = rows.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        Elements next(String selector) {
            Element row = this.rowIterator.next();
            return row.select(selector);
        }

        @Override
        public Elements next() {
            return this.next("th,td");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("NFW - can't remove!");
        }
    }
}

