/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.csv.CsvFilterableTable;
import org.apache.calcite.adapter.csv.JsonTable;
import org.apache.calcite.adapter.file.FileTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;

class FileSchema
extends AbstractSchema {
    private final ImmutableList<Map<String, Object>> tables;
    private final File baseDirectory;

    FileSchema(SchemaPlus parentSchema, String name, File baseDirectory, List<Map<String, Object>> tables) {
        this.tables = ImmutableList.copyOf(tables);
        this.baseDirectory = baseDirectory;
    }

    private static String trim(String s, String suffix) {
        String trimmed = FileSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map tableDef : this.tables) {
            String tableName = (String)tableDef.get("name");
            try {
                this.addTable((ImmutableMap.Builder<String, Table>)builder, tableDef);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to instantiate table for: " + tableName);
            }
        }
        Source baseSource = Sources.of((File)this.baseDirectory);
        File[] files = this.baseDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameSansGz = FileSchema.trim(name, ".gz");
                return nameSansGz.endsWith(".csv") || nameSansGz.endsWith(".json");
            }
        });
        if (files == null) {
            System.out.println("directory " + this.baseDirectory + " not found");
            files = new File[]{};
        }
        for (File file : files) {
            Source source = Sources.of((File)file);
            Source sourceSansGz = source.trim(".gz");
            Source sourceSansJson = sourceSansGz.trimOrNull(".json");
            if (sourceSansJson != null) {
                JsonTable table = new JsonTable(source);
                builder.put((Object)sourceSansJson.relative(baseSource).path(), (Object)table);
                continue;
            }
            Source sourceSansCsv = sourceSansGz.trimOrNull(".csv");
            if (sourceSansCsv == null) continue;
            this.addTable((ImmutableMap.Builder<String, Table>)builder, source, sourceSansCsv.relative(baseSource).path(), null);
        }
        return builder.build();
    }

    private boolean addTable(ImmutableMap.Builder<String, Table> builder, Map<String, Object> tableDef) throws MalformedURLException {
        String tableName = (String)tableDef.get("name");
        String url = (String)tableDef.get("url");
        Source source0 = Sources.url((String)url);
        Source source = this.baseDirectory == null ? source0 : Sources.of((File)this.baseDirectory).append(source0);
        return this.addTable(builder, source, tableName, tableDef);
    }

    private boolean addTable(ImmutableMap.Builder<String, Table> builder, Source source, String tableName, Map<String, Object> tableDef) {
        Source sourceSansGz = source.trim(".gz");
        Source sourceSansJson = sourceSansGz.trimOrNull(".json");
        if (sourceSansJson != null) {
            JsonTable table = new JsonTable(source);
            builder.put(Util.first((Object)tableName, (Object)sourceSansJson.path()), (Object)table);
            return true;
        }
        Source sourceSansCsv = sourceSansGz.trimOrNull(".csv");
        if (sourceSansCsv != null) {
            CsvFilterableTable table = new CsvFilterableTable(source, null);
            builder.put(Util.first((Object)tableName, (Object)sourceSansCsv.path()), (Object)table);
            return true;
        }
        if (tableDef != null) {
            try {
                FileTable table = FileTable.create(source, tableDef);
                builder.put(Util.first((Object)tableName, (Object)source.path()), (Object)table);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate table for: " + tableName);
            }
        }
        return false;
    }
}

