/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.example.maze;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.apache.calcite.linq4j.Enumerator;

class Maze {
    private final int width;
    final int height;
    private final int[] regions;
    private final boolean[] ups;
    private final boolean[] lefts;
    static final boolean DEBUG = false;
    private final boolean horizontal = false;
    private final boolean spiral = false;

    public Maze(int width, int height) {
        this.width = width;
        this.height = height;
        this.regions = new int[width * height];
        for (int i = 0; i < this.regions.length; ++i) {
            this.regions[i] = i;
        }
        this.ups = new boolean[width * height + width];
        this.lefts = new boolean[width * height + 1];
    }

    private int region(int cell) {
        int region = this.regions[cell];
        if (region == cell) {
            return region;
        }
        this.regions[cell] = this.region(region);
        return this.regions[cell];
    }

    public void print(PrintWriter pw, boolean space) {
        pw.println();
        StringBuilder b = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        CellContent cellContent = space ? new CellContent(){

            @Override
            public String get(int c) {
                return "  ";
            }
        } : new CellContent(){

            @Override
            public String get(int c) {
                String s = Maze.this.region(c) + "";
                return s.length() == 1 ? " " + s : s;
            }
        };
        for (int y = 0; y < this.height; ++y) {
            this.row(cellContent, b, b2, y);
            pw.println(b.toString());
            pw.println(b2.toString());
            b.setLength(0);
            b2.setLength(0);
        }
        for (int x = 0; x < this.width; ++x) {
            pw.print("+--");
        }
        pw.println('+');
        pw.flush();
    }

    public Enumerator<String> enumerator(final Set<Integer> solutionSet) {
        final CellContent cellContent = solutionSet == null ? CellContent.SPACE : new CellContent(){

            @Override
            public String get(int c) {
                return solutionSet.contains(c) ? "* " : "  ";
            }
        };
        return new Enumerator<String>(){
            int i = -1;
            final StringBuilder b = new StringBuilder();
            final StringBuilder b2 = new StringBuilder();

            public String current() {
                return this.i % 2 == 0 ? this.b.toString() : this.b2.toString();
            }

            public boolean moveNext() {
                if (this.i >= Maze.this.height * 2) {
                    return false;
                }
                ++this.i;
                if (this.i % 2 == 0) {
                    this.b.setLength(0);
                    this.b2.setLength(0);
                    Maze.this.row(cellContent, this.b, this.b2, this.i / 2);
                }
                return true;
            }

            public void reset() {
                this.i = -1;
            }

            public void close() {
            }
        };
    }

    private void row(CellContent cellContent, StringBuilder b, StringBuilder b2, int y) {
        int x;
        int c0 = y * this.width;
        for (x = 0; x < this.width; ++x) {
            b.append('+');
            b.append(this.ups[c0 + x] ? "  " : "--");
        }
        b.append('+');
        if (y == this.height) {
            return;
        }
        for (x = 0; x < this.width; ++x) {
            b2.append(this.lefts[c0 + x] ? (char)' ' : '|').append(cellContent.get(c0 + x));
        }
        b2.append('|');
    }

    public Maze layout(Random random, PrintWriter pw) {
        int[] candidates = new int[this.width * this.height - this.width + this.width * this.height - this.height];
        int z = 0;
        int c = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (x > 0) {
                    candidates[z++] = c;
                }
                ++c;
                if (y > 0) {
                    candidates[z++] = c;
                }
                ++c;
            }
        }
        assert (z == candidates.length);
        this.shuffle(random, candidates);
        for (int candidate : candidates) {
            int region;
            boolean up = (candidate & 1) != 0;
            int c2 = candidate >> 1;
            if (up) {
                region = this.region(c2 - this.width);
                if (this.region(c2) == region) continue;
                this.ups[c2] = true;
                this.regions[this.regions[c2]] = region;
                this.regions[c2] = region;
                continue;
            }
            region = this.region(c2 - 1);
            if (this.region(c2) == region) continue;
            this.lefts[c2] = true;
            this.regions[this.regions[c2]] = region;
            this.regions[c2] = region;
        }
        return this;
    }

    Set<Integer> solve(int x, int y) {
        int c = y * this.width + x;
        int target = this.regions.length - 1;
        Direction d = Direction.UP;
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayDeque<Direction> fromStack = new ArrayDeque<Direction>();
        ArrayDeque<Direction> directionStack = new ArrayDeque<Direction>();
        Direction from = Direction.BACKTRACK;
        int cNext = 0;
        Direction dNext = Direction.UP;
        boolean move = false;
        while (true) {
            switch (d) {
                case UP: {
                    move = from != Direction.DOWN && this.ups[c];
                    cNext = c - this.width;
                    dNext = Direction.LEFT;
                    break;
                }
                case LEFT: {
                    move = from != Direction.RIGHT && this.lefts[c];
                    cNext = c - 1;
                    dNext = Direction.DOWN;
                    break;
                }
                case DOWN: {
                    move = from != Direction.UP && c + this.width < this.regions.length && this.ups[c + this.width];
                    cNext = c + this.width;
                    dNext = Direction.RIGHT;
                    break;
                }
                case RIGHT: {
                    move = from != Direction.LEFT && c % this.width < this.width - 1 && this.lefts[c + 1];
                    cNext = c + 1;
                    dNext = Direction.BACKTRACK;
                    break;
                }
                case BACKTRACK: {
                    move = false;
                    do {
                        c = (Integer)list.remove(list.size() - 1);
                        dNext = (Direction)((Object)directionStack.pop());
                        from = (Direction)((Object)fromStack.pop());
                    } while (dNext == Direction.BACKTRACK);
                }
            }
            if (move) {
                directionStack.push(dNext);
                fromStack.push(from);
                list.add(c);
                if (cNext == target) {
                    list.add(cNext);
                    return new LinkedHashSet<Integer>(list);
                }
                from = d;
                d = Direction.UP;
                c = cNext;
                continue;
            }
            d = dNext;
        }
    }

    private void shuffle(Random random, int[] ints) {
        for (int i = ints.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            int t = ints[j];
            ints[j] = ints[i];
            ints[i] = t;
        }
    }

    static interface CellContent {
        public static final CellContent SPACE = new CellContent(){

            @Override
            public String get(int c) {
                return "  ";
            }
        };

        public String get(int var1);
    }

    private static enum Direction {
        UP,
        LEFT,
        DOWN,
        RIGHT,
        BACKTRACK;

    }
}

