/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.example.maze;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.example.maze.Maze;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class MazeTable
extends AbstractTable
implements ScannableTable {
    final int width;
    final int height;
    final int seed;
    final boolean solution;

    private MazeTable(int width, int height, int seed, boolean solution) {
        this.width = width;
        this.height = height;
        this.seed = seed;
        this.solution = solution;
    }

    public static ScannableTable generate(int width, int height, int seed) {
        return new MazeTable(width, height, seed, false);
    }

    public static ScannableTable solve(int width, int height, int seed) {
        return new MazeTable(width, height, seed, true);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return typeFactory.builder().add("S", SqlTypeName.VARCHAR, this.width * 3 + 1).build();
    }

    public Enumerable<Object[]> scan(DataContext root) {
        Random random = this.seed >= 0 ? new Random(this.seed) : new Random();
        final Maze maze = new Maze(this.width, this.height);
        PrintWriter pw = Util.printWriter((OutputStream)System.out);
        maze.layout(random, pw);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                Set<Integer> solutionSet = MazeTable.this.solution ? maze.solve(0, 0) : null;
                return Linq4j.transform(maze.enumerator(solutionSet), (Function1)new Function1<String, Object[]>(){

                    public Object[] apply(String s) {
                        return new Object[]{s};
                    }
                });
            }
        };
    }
}

