/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.sql.SqlKind;

public class CsvFilterableTable
extends CsvTable
implements FilterableTable {
    CsvFilterableTable(File file, RelProtoDataType protoRowType) {
        super(file, protoRowType);
    }

    public String toString() {
        return "CsvFilterableTable";
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
        Object[] filterValues = new String[this.fieldTypes.size()];
        Iterator<RexNode> i = filters.iterator();
        while (i.hasNext()) {
            RexNode filter = i.next();
            if (!this.addFilter(filter, filterValues)) continue;
            i.remove();
        }
        int[] fields = CsvEnumerator.identityList(this.fieldTypes.size());
        return new AbstractEnumerable<Object[]>((String[])filterValues, fields){
            final /* synthetic */ String[] val$filterValues;
            final /* synthetic */ int[] val$fields;
            {
                this.val$filterValues = stringArray;
                this.val$fields = nArray;
            }

            public Enumerator<Object[]> enumerator() {
                return new CsvEnumerator<Object[]>(CsvFilterableTable.this.file, this.val$filterValues, new CsvEnumerator.ArrayRowConverter(CsvFilterableTable.this.fieldTypes, this.val$fields));
            }
        };
    }

    private boolean addFilter(RexNode filter, Object[] filterValues) {
        if (filter.isA(SqlKind.EQUALS)) {
            int index;
            RexCall call = (RexCall)filter;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).operands.get(0);
            }
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexInputRef && right instanceof RexLiteral && filterValues[index = ((RexInputRef)left).getIndex()] == null) {
                filterValues[index] = ((RexLiteral)right).getValue2().toString();
                return true;
            }
        }
        return false;
    }
}

