/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Util;
import org.junit.Test;

public class ElasticsearchAdapterIT {
    private static final boolean ENABLED = Util.getBooleanProperty((String)"calcite.test.elasticsearch", (boolean)true);
    private static final ImmutableMap<String, String> ZIPS = ImmutableMap.of((Object)"model", (Object)ElasticsearchAdapterIT.class.getResource("/elasticsearch-zips-model.json").getPath());

    private boolean enabled() {
        return ENABLED;
    }

    private static Function<List, Void> elasticsearchChecker(final String ... strings) {
        return new Function<List, Void>(){

            @Nullable
            public Void apply(@Nullable List actual) {
                Object[] actualArray = actual == null || actual.isEmpty() ? null : ((List)actual.get(0)).toArray();
                CalciteAssert.assertArrayEqual((String)"expected Elasticsearch query not found", (Object[])strings, (Object[])actualArray);
                return null;
            }
        };
    }

    @Test
    public void testSort() {
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], dir0=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select * from zips order by \"state\"").returnsCount(10).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], dir0=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])");
    }

    @Test
    public void testSortLimit() {
        String sql = "select \"state\", \"id\" from zips\norder by \"state\", \"id\" offset 2 rows fetch next 3 rows only";
        CalciteAssert.that().with(ZIPS).query("select \"state\", \"id\" from zips\norder by \"state\", \"id\" offset 2 rows fetch next 3 rows only").returnsUnordered(new String[]{"state=AK; id=99503", "state=AK; id=99504", "state=AK; id=99505"}).queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"fields\" : [\"state\", \"id\"], \"script_fields\": {}", "\"sort\": [ {\"state\": \"asc\"}, {\"id\": \"asc\"}]", "\"from\": 2", "\"size\": 3"));
    }

    @Test
    public void testOffsetLimit() {
        String sql = "select \"state\", \"id\" from zips\noffset 2 fetch next 3 rows only";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"id\" from zips\noffset 2 fetch next 3 rows only").runs().queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"from\": 2", "\"size\": 3", "\"fields\" : [\"state\", \"id\"], \"script_fields\": {}"));
    }

    @Test
    public void testLimit() {
        String sql = "select \"state\", \"id\" from zips\nfetch next 3 rows only";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"id\" from zips\nfetch next 3 rows only").runs().queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"size\": 3", "\"fields\" : [\"state\", \"id\"], \"script_fields\": {}"));
    }

    @Test
    public void testFilterSort() {
        String sql = "select * from zips\nwhere \"city\" = 'SPRINGFIELD' and \"id\" >= '70000'\norder by \"state\", \"id\"";
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], sort1=[$5], dir0=[ASC], dir1=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchFilter(condition=[AND(=(CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'SPRINGFIELD'), >=(CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", '70000'))])\n        ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select * from zips\nwhere \"city\" = 'SPRINGFIELD' and \"id\" >= '70000'\norder by \"state\", \"id\"").returnsOrdered(new String[]{"city=SPRINGFIELD; longitude=-92.54567; latitude=35.274879; pop=752; state=AR; id=72157", "city=SPRINGFIELD; longitude=-102.617322; latitude=37.406727; pop=1992; state=CO; id=81073", "city=SPRINGFIELD; longitude=-90.577479; latitude=30.415738; pop=5597; state=LA; id=70462", "city=SPRINGFIELD; longitude=-123.015259; latitude=44.06106; pop=32384; state=OR; id=97477", "city=SPRINGFIELD; longitude=-122.917108; latitude=44.056056; pop=27521; state=OR; id=97478"}).queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"query\" : {\"constant_score\":{\"filter\":{\"bool\":{\"must\":[{\"term\":{\"city\":\"springfield\"}},{\"range\":{\"id\":{\"gte\":\"70000\"}}}]}}}}", "\"fields\" : [\"city\", \"pop\", \"state\", \"id\"], \"script_fields\": {\"longitude\":{\"script\":\"_source.loc[0]\"}, \"latitude\":{\"script\":\"_source.loc[1]\"}}", "\"sort\": [ {\"state\": \"asc\"}, {\"id\": \"asc\"}]")).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], sort1=[$5], dir0=[ASC], dir1=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchFilter(condition=[AND(=(CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'SPRINGFIELD'), >=(CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", '70000'))])\n        ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])");
    }

    @Test
    public void testFilterSortDesc() {
        String sql = "select * from zips\nwhere \"pop\" BETWEEN 20000 AND 20100\norder by \"state\" desc, \"pop\"";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select * from zips\nwhere \"pop\" BETWEEN 20000 AND 20100\norder by \"state\" desc, \"pop\"").limit(4).returnsOrdered(new String[]{"city=SHERIDAN; longitude=-106.964795; latitude=44.78486; pop=20025; state=WY; id=82801", "city=MOUNTLAKE TERRAC; longitude=-122.304036; latitude=47.793061; pop=20059; state=WA; id=98043", "city=FALMOUTH; longitude=-77.404537; latitude=38.314557; pop=20039; state=VA; id=22405", "city=FORT WORTH; longitude=-97.318409; latitude=32.725551; pop=20012; state=TX; id=76104"});
    }

    @Test
    public void testFilterRedundant() {
        String sql = "select * from zips\nwhere \"state\" > 'CA' and \"state\" < 'AZ' and \"state\" = 'OK'";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select * from zips\nwhere \"state\" > 'CA' and \"state\" < 'AZ' and \"state\" = 'OK'").runs().queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"query\" : {\"constant_score\":{\"filter\":{\"bool\":{\"must\":[{\"term\":{\"state\":\"ok\"}}]}}}}", "\"fields\" : [\"city\", \"pop\", \"state\", \"id\"], \"script_fields\": {\"longitude\":{\"script\":\"_source.loc[0]\"}, \"latitude\":{\"script\":\"_source.loc[1]\"}}"));
    }

    @Test
    public void testInPlan() {
        String[] searches = new String[]{"\"query\" : {\"constant_score\":{\"filter\":{\"bool\":{\"should\":[{\"bool\":{\"must\":[{\"term\":{\"pop\":20012}}]}},{\"bool\":{\"must\":[{\"term\":{\"pop\":15590}}]}}]}}}}", "\"fields\" : [\"city\", \"pop\", \"state\", \"id\"], \"script_fields\": {\"longitude\":{\"script\":\"_source.loc[0]\"}, \"latitude\":{\"script\":\"_source.loc[1]\"}}"};
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select * from zips where \"pop\" in (20012, 15590)").returnsUnordered(new String[]{"city=COVINA; longitude=-117.884285; latitude=34.08596; pop=15590; state=CA; id=91723", "city=ARLINGTON; longitude=-97.091987; latitude=32.654752; pop=15590; state=TX; id=76018", "city=CROFTON; longitude=-76.680166; latitude=39.011163; pop=15590; state=MD; id=21114", "city=FORT WORTH; longitude=-97.318409; latitude=32.725551; pop=20012; state=TX; id=76104", "city=DINUBA; longitude=-119.39087; latitude=36.534931; pop=20012; state=CA; id=93618"}).queryContains(ElasticsearchAdapterIT.elasticsearchChecker(searches));
    }

    @Test
    public void testZips() {
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"city\" from zips").returnsCount(10);
    }

    @Test
    public void testProject() {
        String sql = "select \"state\", \"city\", 0 as \"zero\"\nfrom zips\norder by \"state\", \"city\"";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"city\", 0 as \"zero\"\nfrom zips\norder by \"state\", \"city\"").limit(2).returnsUnordered(new String[]{"state=AK; city=ELMENDORF AFB; zero=0", "state=AK; city=EIELSON AFB; zero=0"}).queryContains(ElasticsearchAdapterIT.elasticsearchChecker("\"sort\": [ {\"state\": \"asc\"}, {\"city\": \"asc\"}]", "\"fields\" : [\"state\", \"city\"], \"script_fields\": {\"zero\":{\"script\": \"0\"}}"));
    }

    @Test
    public void testFilter() {
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchProject(state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n    ElasticsearchFilter(condition=[=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA')])\n      ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])";
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"city\" from zips where \"state\" = 'CA'").limit(2).returnsUnordered(new String[]{"state=CA; city=LOS ANGELES", "state=CA; city=LOS ANGELES"}).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchProject(state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n    ElasticsearchFilter(condition=[=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA')])\n      ElasticsearchTableScan(table=[[elasticsearch_raw, zips]])");
    }

    @Test
    public void testFilterReversed() {
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"city\" from zips where 'WI' < \"state\"").limit(2).returnsUnordered(new String[]{"state=WV; city=WELCH", "state=WV; city=HANOVER"});
        CalciteAssert.that().enable(this.enabled()).with(ZIPS).query("select \"state\", \"city\" from zips where \"state\" > 'WI'").limit(2).returnsUnordered(new String[]{"state=WV; city=WELCH", "state=WV; city=HANOVER"});
    }
}

