/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchMethod;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class ElasticsearchToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected ElasticsearchToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ElasticsearchToEnumerableConverter(this.getCluster(), traitSet, (RelNode)ElasticsearchToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer prefer) {
        BlockBuilder list = new BlockBuilder();
        ElasticsearchRel.Implementor elasticsearchImplementor = new ElasticsearchRel.Implementor();
        elasticsearchImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)prefer.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", (Expression)ElasticsearchToEnumerableConverter.constantArrayList(Pair.zip(ElasticsearchRules.elasticsearchFieldNames(rowType), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression table = list.append("table", elasticsearchImplementor.table.getExpression(ElasticsearchTable.ElasticsearchQueryable.class));
        List<String> opList = elasticsearchImplementor.list;
        Expression ops = list.append("ops", (Expression)ElasticsearchToEnumerableConverter.constantArrayList(opList, String.class));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)ElasticsearchMethod.ELASTICSEARCH_QUERYABLE_FIND.method, (Expression[])new Expression[]{ops, fields}));
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Elasticsearch: " + opList);
        }
        Hook.QUERY_PLAN.run(opList);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, ElasticsearchToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, (Function)new Function<T, Expression>(){

            @Nullable
            public Expression apply(@Nullable T t) {
                return Expressions.constant(t);
            }
        });
    }
}

