/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class ElasticsearchSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> map = operand;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        try {
            Map coordinates = (Map)mapper.readValue((String)map.get("coordinates"), (TypeReference)new TypeReference<Map<String, Integer>>(){});
            Map userConfig = (Map)mapper.readValue((String)map.get("userConfig"), (TypeReference)new TypeReference<Map<String, String>>(){});
            String index = (String)map.get("index");
            return new ElasticsearchSchema(coordinates, userConfig, index);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse values from json", e);
        }
    }
}

