/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class ElasticsearchProject
extends Project
implements ElasticsearchRel {
    public ElasticsearchProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet relTraitSet, RelNode input, List<RexNode> projects, RelDataType relDataType) {
        return new ElasticsearchProject(this.getCluster(), this.traitSet, input, projects, relDataType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        ElasticsearchRules.RexToElasticsearchTranslator translator = new ElasticsearchRules.RexToElasticsearchTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), ElasticsearchRules.elasticsearchFieldNames(this.getInput().getRowType()));
        ArrayList<String> findItems = new ArrayList<String>();
        ArrayList<String> scriptFieldItems = new ArrayList<String>();
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            if (expr.equals("\"" + name + "\"")) {
                findItems.add(ElasticsearchRules.quote(name));
                continue;
            }
            if (expr.matches("\"literal\":.+")) {
                scriptFieldItems.add(ElasticsearchRules.quote(name) + ":{\"script\": " + expr.split(":")[1] + "}");
                continue;
            }
            scriptFieldItems.add(ElasticsearchRules.quote(name) + ":{\"script\":\"_source." + expr.replaceAll("\"", "") + "\"}");
        }
        String findString = Util.toString(findItems, (String)"", (String)", ", (String)"");
        String scriptFieldString = "\"script_fields\": {" + Util.toString(scriptFieldItems, (String)"", (String)", ", (String)"") + "}";
        String fieldString = "\"fields\" : [" + findString + "]" + ", " + scriptFieldString;
        for (String opfield : implementor.list) {
            if (!opfield.startsWith("\"fields\"")) continue;
            implementor.list.remove(opfield);
        }
        implementor.add(fieldString);
    }
}

