/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSchemaFactory
implements SchemaFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSchemaFactory.class);

    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> map = operand;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        try {
            List<HttpHost> hosts;
            if (map.containsKey("hosts")) {
                List configHosts = (List)mapper.readValue((String)map.get("hosts"), (TypeReference)new TypeReference<List<String>>(){});
                hosts = configHosts.stream().map(host -> HttpHost.create((String)host)).collect(Collectors.toList());
            } else if (map.containsKey("coordinates")) {
                Map coordinates = (Map)mapper.readValue((String)map.get("coordinates"), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                hosts = coordinates.entrySet().stream().map(entry -> new HttpHost((String)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
                LOGGER.warn("Prefer using hosts, coordinates is deprecated.");
            } else {
                throw new IllegalArgumentException("Both 'coordinates' and 'hosts' is missing in configuration. Provide one of them.");
            }
            String pathPrefix = (String)map.get("pathPrefix");
            String username = (String)map.get("username");
            String password = (String)map.get("password");
            RestClient client = ElasticsearchSchemaFactory.connect(hosts, pathPrefix, username, password);
            String index = (String)map.get("index");
            return new ElasticsearchSchema(client, new ObjectMapper(), index);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse values from json", e);
        }
    }

    private static RestClient connect(List<HttpHost> hosts, String pathPrefix, String username, String password) {
        Objects.requireNonNull(hosts, "hosts or coordinates");
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"no ES hosts specified");
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[hosts.size()]));
        if (!Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchSchemaFactory.lambda$connect$2((CredentialsProvider)credentialsProvider, arg_0));
        }
        if (pathPrefix != null && !pathPrefix.isEmpty()) {
            builder.setPathPrefix(pathPrefix);
        }
        return builder.build();
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$connect$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

