/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchConstants;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;

public class ElasticsearchProject
extends Project
implements ElasticsearchRel {
    ElasticsearchProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, projects, rowType);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet relTraitSet, RelNode input, List<RexNode> projects, RelDataType relDataType) {
        return new ElasticsearchProject(this.getCluster(), this.traitSet, input, projects, relDataType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List<String> inFields = ElasticsearchRules.elasticsearchFieldNames(this.getInput().getRowType());
        ElasticsearchRules.RexToElasticsearchTranslator translator = new ElasticsearchRules.RexToElasticsearchTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), inFields);
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> scriptFields = new ArrayList<String>();
        boolean hasSelectStar = false;
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            hasSelectStar |= ElasticsearchConstants.isSelectAll(name);
            if (ElasticsearchRules.isItem((RexNode)pair.left)) {
                implementor.addExpressionItemMapping(name, expr);
                fields.add(expr);
                continue;
            }
            if (expr.equals(name)) {
                fields.add(name);
                continue;
            }
            if (expr.matches("\"literal\":.+")) {
                scriptFields.add(ElasticsearchRules.quote(name) + ":{\"script\": " + expr.split(":")[1] + "}");
                continue;
            }
            scriptFields.add(ElasticsearchRules.quote(name) + ":{\"script\":\"" + implementor.elasticsearchTable.scriptedFieldPrefix() + "." + expr.replace("\"", "") + "\"}");
        }
        if (hasSelectStar) {
            return;
        }
        StringBuilder query = new StringBuilder();
        if (scriptFields.isEmpty()) {
            List newList = fields.stream().filter(f -> !"_id".equals(f)).map(ElasticsearchRules::quote).collect(Collectors.toList());
            String findString = String.join((CharSequence)", ", newList);
            query.append("\"_source\" : [").append(findString).append("]");
        } else {
            for (String field : fields) {
                scriptFields.add(ElasticsearchRules.quote(field) + ":{\"script\": \"" + implementor.elasticsearchTable.scriptedFieldPrefix() + "." + field + "\"}");
            }
            query.append("\"script_fields\": {" + String.join((CharSequence)", ", scriptFields) + "}");
        }
        implementor.list.removeIf(l -> l.startsWith("\"_source\""));
        implementor.add("{" + query.toString() + "}");
    }
}

