/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.Assert;

public class ElasticsearchChecker {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});

    private ElasticsearchChecker() {
    }

    public static Consumer<List> elasticsearchChecker(String ... strings) {
        Objects.requireNonNull(strings, "strings");
        return a -> {
            ObjectNode actual = a == null || a.isEmpty() ? null : (ObjectNode)a.get(0);
            actual = ElasticsearchChecker.expandDots(actual);
            try {
                String json = "{" + Arrays.stream(strings).collect(Collectors.joining(",")) + "}";
                ObjectNode expected = (ObjectNode)MAPPER.readTree(json);
                expected = ElasticsearchChecker.expandDots(expected);
                if (!expected.equals((Object)actual)) {
                    Assert.assertEquals((String)"expected and actual Elasticsearch queries do not match", (Object)MAPPER.writeValueAsString((Object)expected), (Object)MAPPER.writeValueAsString((Object)actual));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static <T extends JsonNode> T expandDots(T parent) {
        Objects.requireNonNull(parent, "parent");
        if (parent.isValueNode()) {
            return (T)parent.deepCopy();
        }
        if (parent.isArray()) {
            ArrayNode arr = (ArrayNode)parent;
            ArrayNode copy = arr.arrayNode();
            arr.elements().forEachRemaining(e -> copy.add(ElasticsearchChecker.expandDots(e)));
            return (T)copy;
        }
        ObjectNode objectNode = (ObjectNode)parent;
        ObjectNode copy = objectNode.objectNode();
        objectNode.fields().forEachRemaining(e -> {
            String property = (String)e.getKey();
            JsonNode node = (JsonNode)e.getValue();
            String[] names = property.split("\\.");
            ObjectNode copy2 = copy;
            for (int i = 0; i < names.length - 1; ++i) {
                copy2 = copy2.with(names[i]);
            }
            copy2.set(names[names.length - 1], ElasticsearchChecker.expandDots(node));
        });
        return (T)copy;
    }
}

