/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ElasticsearchSearchResult {
    private final SearchHits hits;
    private final long took;

    @JsonCreator
    ElasticsearchSearchResult(@JsonProperty(value="hits") SearchHits hits, @JsonProperty(value="took") long took) {
        this.hits = Objects.requireNonNull(hits, "hits");
        this.took = took;
    }

    public SearchHits searchHits() {
        return this.hits;
    }

    public Duration took() {
        return Duration.ofMillis(this.took);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SearchHit {
        private final String id;
        private final Map<String, Object> source;
        private final Map<String, Object> fields;

        @JsonCreator
        private SearchHit(@JsonProperty(value="_id") String id, @JsonProperty(value="_source") Map<String, Object> source, @JsonProperty(value="fields") Map<String, Object> fields) {
            this.id = Objects.requireNonNull(id, "id");
            if (source == null && fields == null) {
                String message = String.format(Locale.ROOT, "Both '_source' and 'fields' are missing for %s", id);
                throw new IllegalArgumentException(message);
            }
            if (source != null && fields != null) {
                String message = String.format(Locale.ROOT, "Both '_source' and 'fields' are populated (non-null) for %s", id);
                throw new IllegalArgumentException(message);
            }
            this.source = source;
            this.fields = fields;
        }

        public String id() {
            return this.id;
        }

        Object value(String name) {
            Objects.requireNonNull(name, "name");
            if (!this.sourceOrFields().containsKey(name)) {
                String message = String.format(Locale.ROOT, "Attribute %s not found in search result %s", name, this.id);
                throw new IllegalArgumentException(message);
            }
            if (this.source != null) {
                return this.source.get(name);
            }
            if (this.fields != null) {
                Object field = this.fields.get(name);
                if (field instanceof Iterable) {
                    Iterator iter = ((Iterable)field).iterator();
                    return iter.hasNext() ? iter.next() : null;
                }
                return field;
            }
            throw new AssertionError((Object)("Shouldn't get here: " + this.id));
        }

        public Map<String, Object> source() {
            return this.source;
        }

        public Map<String, Object> fields() {
            return this.fields;
        }

        public Map<String, Object> sourceOrFields() {
            return this.source != null ? this.source : this.fields;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SearchHits {
        private final long total;
        private final List<SearchHit> hits;

        @JsonCreator
        SearchHits(@JsonProperty(value="total") long total, @JsonProperty(value="hits") List<SearchHit> hits) {
            this.total = total;
            this.hits = Objects.requireNonNull(hits, "hits");
        }

        public List<SearchHit> hits() {
            return this.hits;
        }

        public long total() {
            return this.total;
        }
    }
}

