/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchConstants;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchMapping;

final class ElasticsearchJson {
    private ElasticsearchJson() {
    }

    static void visitValueNodes(Aggregations aggregations, Consumer<Map<String, Object>> consumer) {
        Objects.requireNonNull(aggregations, "aggregations");
        Objects.requireNonNull(consumer, "consumer");
        LinkedHashMap<RowKey, List> rows = new LinkedHashMap<RowKey, List>();
        BiConsumer<RowKey, MultiValue> cons = (r, v) -> rows.computeIfAbsent((RowKey)r, ignore -> new ArrayList()).add(v);
        aggregations.forEach(a -> ElasticsearchJson.visitValueNodes(a, new ArrayList<Bucket>(), cons));
        rows.forEach((k, v) -> {
            if (v.stream().allMatch(val -> val instanceof GroupValue)) {
                v.forEach(tuple -> {
                    LinkedHashMap<String, Object> groupRow = new LinkedHashMap<String, Object>(((RowKey)k).keys);
                    groupRow.put(tuple.getName(), tuple.value());
                    consumer.accept(groupRow);
                });
            } else {
                LinkedHashMap row = new LinkedHashMap(((RowKey)k).keys);
                v.forEach(val -> row.put(val.getName(), val.value()));
                consumer.accept(row);
            }
        });
    }

    static void visitMappingProperties(ObjectNode mapping, BiConsumer<String, String> consumer) {
        Objects.requireNonNull(mapping, "mapping");
        Objects.requireNonNull(consumer, "consumer");
        ElasticsearchJson.visitMappingProperties(new ArrayDeque<String>(), mapping, consumer);
    }

    private static void visitMappingProperties(Deque<String> path, ObjectNode mapping, BiConsumer<String, String> consumer) {
        Objects.requireNonNull(mapping, "mapping");
        if (mapping.isMissingNode()) {
            return;
        }
        if (mapping.has("properties")) {
            ElasticsearchJson.visitMappingProperties(path, (ObjectNode)mapping.get("properties"), consumer);
            return;
        }
        if (mapping.has("type")) {
            consumer.accept(String.join((CharSequence)".", path), mapping.get("type").asText());
            return;
        }
        Iterable iter = () -> ((ObjectNode)mapping).fields();
        for (Map.Entry entry : iter) {
            String name = (String)entry.getKey();
            ObjectNode node = (ObjectNode)entry.getValue();
            path.add(name);
            ElasticsearchJson.visitMappingProperties(path, node, consumer);
            path.removeLast();
        }
    }

    private static void visitValueNodes(Aggregation aggregation, List<Bucket> parents, BiConsumer<RowKey, MultiValue> consumer) {
        if (aggregation instanceof MultiValue) {
            RowKey key = new RowKey(parents);
            consumer.accept(key, (MultiValue)aggregation);
            return;
        }
        if (aggregation instanceof Bucket) {
            Bucket bucket = (Bucket)aggregation;
            if (bucket.hasNoAggregations()) {
                ElasticsearchJson.visitValueNodes(GroupValue.of(bucket.getName(), bucket.key()), parents, consumer);
                return;
            }
            parents.add(bucket);
            bucket.getAggregations().forEach(a -> ElasticsearchJson.visitValueNodes(a, parents, consumer));
            parents.remove(parents.size() - 1);
        } else if (aggregation instanceof HasAggregations) {
            HasAggregations children = (HasAggregations)((Object)aggregation);
            children.getAggregations().forEach(a -> ElasticsearchJson.visitValueNodes(a, parents, consumer));
        } else if (aggregation instanceof MultiBucketsAggregation) {
            MultiBucketsAggregation multi = (MultiBucketsAggregation)aggregation;
            multi.buckets().forEach(b -> ElasticsearchJson.visitValueNodes(b, parents, consumer));
        }
    }

    static class AggregationsDeserializer
    extends StdDeserializer<Aggregations> {
        private static final Set<String> IGNORE_TOKENS = ImmutableSet.of((Object)"meta", (Object)"buckets", (Object)"value", (Object)"values", (Object)"value_as_string", (Object)"doc_count", (Object[])new String[]{"key", "key_as_string"});

        AggregationsDeserializer() {
            super(Aggregations.class);
        }

        public Aggregations deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            ObjectNode node = (ObjectNode)parser.getCodec().readTree(parser);
            return AggregationsDeserializer.parseAggregations(parser, node);
        }

        private static Aggregations parseAggregations(JsonParser parser, ObjectNode node) throws JsonProcessingException {
            ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
            Iterable iter = () -> ((ObjectNode)node).fields();
            for (Map.Entry entry : iter) {
                String name = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                Aggregation agg = null;
                if (value.has("buckets")) {
                    agg = AggregationsDeserializer.parseBuckets(parser, name, (ArrayNode)value.get("buckets"));
                } else if (value.isObject() && !IGNORE_TOKENS.contains(name)) {
                    agg = AggregationsDeserializer.parseValue(parser, name, (ObjectNode)value);
                }
                if (agg == null) continue;
                aggregations.add(agg);
            }
            return new Aggregations(aggregations);
        }

        private static MultiValue parseValue(JsonParser parser, String name, ObjectNode node) throws JsonProcessingException {
            return new MultiValue(name, (Map)parser.getCodec().treeToValue((TreeNode)node, Map.class));
        }

        private static Aggregation parseBuckets(JsonParser parser, String name, ArrayNode nodes) throws JsonProcessingException {
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(nodes.size());
            for (JsonNode b : nodes) {
                buckets.add(AggregationsDeserializer.parseBucket(parser, name, (ObjectNode)b));
            }
            return new MultiBucketsAggregation(name, buckets);
        }

        private static boolean isMissingBucket(JsonNode key) {
            return ElasticsearchMapping.Datatype.isMissingValue(key);
        }

        private static Bucket parseBucket(JsonParser parser, String name, ObjectNode node) throws JsonProcessingException {
            if (!node.has("key")) {
                throw new IllegalArgumentException("No 'key' attribute for " + node);
            }
            JsonNode keyNode = node.get("key");
            Object key = AggregationsDeserializer.isMissingBucket(keyNode) || keyNode.isNull() ? null : (keyNode.isTextual() ? keyNode.textValue() : (keyNode.isNumber() ? keyNode.numberValue() : (keyNode.isBoolean() ? Boolean.valueOf(keyNode.booleanValue()) : parser.getCodec().treeToValue((TreeNode)node, Map.class))));
            return new Bucket(key, name, AggregationsDeserializer.parseAggregations(parser, node));
        }
    }

    static class GroupValue
    extends MultiValue {
        GroupValue(String name, Map<String, Object> values) {
            super(name, values);
        }

        static GroupValue of(String name, Object value) {
            return new GroupValue(name, Collections.singletonMap("value", value));
        }
    }

    static class MultiValue
    implements Aggregation {
        private final String name;
        private final Map<String, Object> values;

        MultiValue(String name, Map<String, Object> values) {
            this.name = Objects.requireNonNull(name, "name");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        public String getName() {
            return this.name;
        }

        Map<String, Object> values() {
            return this.values;
        }

        Object value() {
            if (!this.values().containsKey("value")) {
                String message = String.format(Locale.ROOT, "'value' field not present in %s aggregation", this.getName());
                throw new IllegalStateException(message);
            }
            return this.values().get("value");
        }
    }

    static class Bucket
    implements HasAggregations,
    Aggregation {
        private final Object key;
        private final String name;
        private final Aggregations aggregations;

        Bucket(Object key, String name, Aggregations aggregations) {
            this.key = key;
            this.name = Objects.requireNonNull(name, "name");
            this.aggregations = Objects.requireNonNull(aggregations, "aggregations");
        }

        Object key() {
            return this.key;
        }

        String keyAsString() {
            return Objects.toString(this.key());
        }

        boolean hasNoAggregations() {
            return this.aggregations.asList().isEmpty();
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static class MultiBucketsAggregation
    implements Aggregation {
        private final String name;
        private final List<Bucket> buckets;

        MultiBucketsAggregation(String name, List<Bucket> buckets) {
            this.name = name;
            this.buckets = buckets;
        }

        List<Bucket> buckets() {
            return this.buckets;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    static interface HasAggregations {
        public Aggregations getAggregations();
    }

    static interface Aggregation {
        public String getName();
    }

    @JsonDeserialize(using=AggregationsDeserializer.class)
    static class Aggregations
    implements Iterable<Aggregation> {
        private final List<? extends Aggregation> aggregations;
        private Map<String, Aggregation> aggregationsAsMap;

        Aggregations(List<? extends Aggregation> aggregations) {
            this.aggregations = Objects.requireNonNull(aggregations, "aggregations");
        }

        @Override
        public final Iterator<Aggregation> iterator() {
            return this.asList().iterator();
        }

        final List<Aggregation> asList() {
            return Collections.unmodifiableList(this.aggregations);
        }

        final Map<String, Aggregation> asMap() {
            if (this.aggregationsAsMap == null) {
                LinkedHashMap<String, Aggregation> map = new LinkedHashMap<String, Aggregation>(this.aggregations.size());
                for (Aggregation aggregation : this.aggregations) {
                    map.put(aggregation.getName(), aggregation);
                }
                this.aggregationsAsMap = Collections.unmodifiableMap(map);
            }
            return this.aggregationsAsMap;
        }

        public final <A extends Aggregation> A get(String name) {
            return (A)this.asMap().get(name);
        }

        public final boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.aggregations.equals(((Aggregations)obj).aggregations);
        }

        public final int hashCode() {
            return Objects.hash(this.getClass(), this.aggregations);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SearchHit {
        private final String id;
        private final Map<String, Object> source;
        private final Map<String, Object> fields;

        @JsonCreator
        SearchHit(@JsonProperty(value="_id") String id, @JsonProperty(value="_source") Map<String, Object> source, @JsonProperty(value="fields") Map<String, Object> fields) {
            this.id = Objects.requireNonNull(id, "id");
            if (source == null && fields == null) {
                String message = String.format(Locale.ROOT, "Both '_source' and 'fields' are missing for %s", id);
                throw new IllegalArgumentException(message);
            }
            if (source != null && fields != null) {
                String message = String.format(Locale.ROOT, "Both '_source' and 'fields' are populated (non-null) for %s", id);
                throw new IllegalArgumentException(message);
            }
            this.source = source;
            this.fields = fields;
        }

        public String id() {
            return this.id;
        }

        Object valueOrNull(String name) {
            Objects.requireNonNull(name, "name");
            if (ElasticsearchConstants.isSelectAll(name)) {
                return this.sourceOrFields();
            }
            if (this.fields != null && this.fields.containsKey(name)) {
                Object field = this.fields.get(name);
                if (field instanceof Iterable) {
                    Iterator iter = ((Iterable)field).iterator();
                    return iter.hasNext() ? iter.next() : null;
                }
                return field;
            }
            return SearchHit.valueFromPath(this.source, name);
        }

        private static Object valueFromPath(Map<String, Object> map, String path) {
            if (map == null) {
                return null;
            }
            if (map.containsKey(path)) {
                return map.get(path);
            }
            int index = path.indexOf(46);
            if (index == -1) {
                return null;
            }
            String prefix = path.substring(0, index);
            String suffix = path.substring(index + 1);
            Object maybeMap = map.get(prefix);
            if (maybeMap instanceof Map) {
                return SearchHit.valueFromPath((Map)maybeMap, suffix);
            }
            return null;
        }

        Map<String, Object> source() {
            return this.source;
        }

        Map<String, Object> fields() {
            return this.fields;
        }

        Map<String, Object> sourceOrFields() {
            return this.source != null ? this.source : this.fields;
        }
    }

    static class SearchTotalDeserializer
    extends StdDeserializer<SearchTotal> {
        SearchTotalDeserializer() {
            super(SearchTotal.class);
        }

        public SearchTotal deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            return SearchTotalDeserializer.parseSearchTotal(node);
        }

        private static SearchTotal parseSearchTotal(JsonNode node) {
            Number value = node.isNumber() ? (Number)node.numberValue() : (Number)node.get("value").numberValue();
            return new SearchTotal(value.longValue());
        }
    }

    @JsonDeserialize(using=SearchTotalDeserializer.class)
    static class SearchTotal {
        private final long value;

        SearchTotal(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SearchHits {
        private final SearchTotal total;
        private final List<SearchHit> hits;

        @JsonCreator
        SearchHits(@JsonProperty(value="total") SearchTotal total, @JsonProperty(value="hits") List<SearchHit> hits) {
            this.total = total;
            this.hits = Objects.requireNonNull(hits, "hits");
        }

        public List<SearchHit> hits() {
            return this.hits;
        }

        public SearchTotal total() {
            return this.total;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Result {
        private final SearchHits hits;
        private final Aggregations aggregations;
        private final String scrollId;
        private final long took;

        @JsonCreator
        Result(@JsonProperty(value="hits") SearchHits hits, @JsonProperty(value="aggregations") Aggregations aggregations, @JsonProperty(value="_scroll_id") String scrollId, @JsonProperty(value="took") long took) {
            this.hits = Objects.requireNonNull(hits, "hits");
            this.aggregations = aggregations;
            this.scrollId = scrollId;
            this.took = took;
        }

        SearchHits searchHits() {
            return this.hits;
        }

        Aggregations aggregations() {
            return this.aggregations;
        }

        Duration took() {
            return Duration.ofMillis(this.took);
        }

        Optional<String> scrollId() {
            return Optional.ofNullable(this.scrollId);
        }
    }

    private static class RowKey {
        private final Map<String, Object> keys;
        private final int hashCode;

        private RowKey(Map<String, Object> keys) {
            this.keys = Objects.requireNonNull(keys, "keys");
            this.hashCode = Objects.hashCode(keys);
        }

        private RowKey(List<Bucket> buckets) {
            this(RowKey.toMap(buckets));
        }

        private static Map<String, Object> toMap(Iterable<Bucket> buckets) {
            return StreamSupport.stream(buckets.spliterator(), false).collect(LinkedHashMap::new, (m, v) -> m.put(v.getName(), v.key()), HashMap::putAll);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowKey rowKey = (RowKey)o;
            return this.hashCode == rowKey.hashCode && Objects.equals(this.keys, rowKey.keys);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

