/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.PredicateAnalyzer;
import org.apache.calcite.adapter.elasticsearch.QueryBuilders;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;

public class ElasticsearchFilter
extends Filter
implements ElasticsearchRel {
    ElasticsearchFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public Filter copy(RelTraitSet relTraitSet, RelNode input, RexNode condition) {
        return new ElasticsearchFilter(this.getCluster(), relTraitSet, input, condition);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        ObjectMapper mapper = implementor.elasticsearchTable.mapper;
        PredicateAnalyzerTranslator translator = new PredicateAnalyzerTranslator(mapper);
        try {
            implementor.add(translator.translateMatch(this.condition));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (PredicateAnalyzer.ExpressionNotAnalyzableException e) {
            throw new RuntimeException(e);
        }
    }

    static class PredicateAnalyzerTranslator {
        private final ObjectMapper mapper;

        PredicateAnalyzerTranslator(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
        }

        String translateMatch(RexNode condition) throws IOException, PredicateAnalyzer.ExpressionNotAnalyzableException {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = this.mapper.getFactory().createGenerator((Writer)writer);
            QueryBuilders.constantScoreQuery(PredicateAnalyzer.analyze(condition)).writeJson(generator);
            generator.flush();
            generator.close();
            return "{\"query\" : " + writer.toString() + "}";
        }
    }
}

