/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ProjectionTest {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String NAME = "docs";

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mappings = ImmutableMap.of((Object)"A", (Object)"keyword", (Object)"b", (Object)"keyword", (Object)"cCC", (Object)"keyword", (Object)"DDd", (Object)"keyword");
        NODE.createIndex(NAME, (Map<String, String>)mappings);
        String doc = "{'A': 'aa', 'b': 'bb', 'cCC': 'cc', 'DDd': 'dd'}".replace('\'', '\"');
        NODE.insertDocument(NAME, (ObjectNode)NODE.mapper().readTree(doc));
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), ProjectionTest.NAME));
                String viewSql = String.format(Locale.ROOT, "select cast(_MAP['A'] AS varchar(2)) AS a, cast(_MAP['b'] AS varchar(2)) AS b,  cast(_MAP['cCC'] AS varchar(2)) AS c,  cast(_MAP['DDd'] AS varchar(2)) AS d  from \"elastic\".\"%s\"", ProjectionTest.NAME);
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)viewSql, Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add("VIEW", (Function)macro);
                return connection;
            }
        };
    }

    @Test
    public void projection() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from view").returns("A=aa; B=bb; C=cc; D=dd\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select a, b, c, d from view").returns("A=aa; B=bb; C=cc; D=dd\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select d, c, b, a from view").returns("D=dd; C=cc; B=bb; A=aa\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select a from view").returns("A=aa\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select a, b from view").returns("A=aa; B=bb\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select b, a from view").returns("B=bb; A=aa\n");
    }
}

