/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class Projection2Test {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String NAME = "nested";

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mappings = ImmutableMap.of((Object)"a", (Object)"long", (Object)"b.a", (Object)"long", (Object)"b.b", (Object)"long", (Object)"b.c.a", (Object)"keyword");
        NODE.createIndex(NAME, (Map<String, String>)mappings);
        String doc = "{'a': 1, 'b':{'a': 2, 'b':'3', 'c':{'a': 'foo'}}}".replace('\'', '\"');
        NODE.insertDocument(NAME, (ObjectNode)NODE.mapper().readTree(doc));
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), Projection2Test.NAME));
                String viewSql = String.format(Locale.ROOT, "select _MAP['a'] AS \"a\",  _MAP['b.a']  AS \"b.a\",  _MAP['b.b'] AS \"b.b\",  _MAP['b.c.a'] AS \"b.c.a\"  from \"elastic\".\"%s\"", Projection2Test.NAME);
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)viewSql, Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add("VIEW", (Function)macro);
                return connection;
            }
        };
    }

    @Test
    public void projection() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select \"a\", \"b.a\", \"b.b\", \"b.c.a\" from view").returns("a=1; b.a=2; b.b=3; b.c.a=foo\n");
    }

    @Test
    public void projection2() {
        String sql = String.format(Locale.ROOT, "select _MAP['a'], _MAP['b.a'], _MAP['b.b'], _MAP['b.c.a'], _MAP['missing'], _MAP['b.missing'] from \"elastic\".\"%s\"", NAME);
        CalciteAssert.that().with(this.newConnectionFactory()).query(sql).returns("EXPR$0=1; EXPR$1=2; EXPR$2=3; EXPR$3=foo; EXPR$4=null; EXPR$5=null\n");
    }
}

