/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchNode;
import org.apache.calcite.util.Closer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.transport.TransportAddress;
import org.junit.rules.ExternalResource;

class EmbeddedElasticsearchPolicy
extends ExternalResource {
    private final EmbeddedElasticsearchNode node;
    private final ObjectMapper mapper;
    private final Closer closer;
    private RestClient client;

    private EmbeddedElasticsearchPolicy(EmbeddedElasticsearchNode resource) {
        this.node = Objects.requireNonNull(resource, "resource");
        this.mapper = new ObjectMapper();
        this.closer = new Closer();
        this.closer.add((AutoCloseable)this.node);
    }

    protected void before() throws Throwable {
        this.node.start();
    }

    protected void after() {
        this.closer.close();
    }

    public static EmbeddedElasticsearchPolicy create() {
        return new EmbeddedElasticsearchPolicy(EmbeddedElasticsearchNode.create());
    }

    void createIndex(String index, Map<String, String> mapping) throws IOException {
        Objects.requireNonNull(index, "index");
        Objects.requireNonNull(mapping, "mapping");
        ObjectNode mappings = this.mapper().createObjectNode();
        ObjectNode properties = mappings.with("mappings").with(index).with("properties");
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            EmbeddedElasticsearchPolicy.applyMapping(properties, entry.getKey(), entry.getValue());
        }
        StringEntity entity = new StringEntity(this.mapper().writeValueAsString((Object)mappings), ContentType.APPLICATION_JSON);
        this.restClient().performRequest("PUT", "/" + index, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
    }

    private static void applyMapping(ObjectNode parent, String key, String type) {
        int index = key.indexOf(46);
        if (index > -1) {
            String prefix = key.substring(0, index);
            String suffix = key.substring(index + 1, key.length());
            EmbeddedElasticsearchPolicy.applyMapping(parent.with(prefix).with("properties"), suffix, type);
        } else {
            parent.with(key).put("type", type);
        }
    }

    void insertDocument(String index, ObjectNode document) throws IOException {
        Objects.requireNonNull(index, "index");
        Objects.requireNonNull(document, "document");
        String uri = String.format(Locale.ROOT, "/%s/%s/?refresh", index, index);
        StringEntity entity = new StringEntity(this.mapper().writeValueAsString((Object)document), ContentType.APPLICATION_JSON);
        this.restClient().performRequest("POST", uri, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
    }

    void insertBulk(String index, List<ObjectNode> documents) throws IOException {
        Objects.requireNonNull(index, "index");
        Objects.requireNonNull(documents, "documents");
        if (documents.isEmpty()) {
            return;
        }
        ArrayList<String> bulk = new ArrayList<String>(documents.size() * 2);
        for (ObjectNode doc : documents) {
            bulk.add("{\"index\": {} }");
            bulk.add(this.mapper().writeValueAsString((Object)doc));
        }
        StringEntity entity = new StringEntity(String.join((CharSequence)"\n", bulk) + "\n", ContentType.APPLICATION_JSON);
        String uri = String.format(Locale.ROOT, "/%s/%s/_bulk?refresh", index, index);
        this.restClient().performRequest("POST", uri, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
    }

    ObjectMapper mapper() {
        return this.mapper;
    }

    RestClient restClient() {
        if (this.client != null) {
            return this.client;
        }
        RestClient client = RestClient.builder((HttpHost[])new HttpHost[]{this.httpHost()}).build();
        this.closer.add((AutoCloseable)client);
        this.client = client;
        return client;
    }

    HttpHost httpHost() {
        TransportAddress address = this.httpAddress();
        return new HttpHost(address.getAddress(), address.getPort());
    }

    private TransportAddress httpAddress() {
        return this.node.httpAddress();
    }
}

