/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ElasticsearchChecker;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class ElasticSearchAdapterTest {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String ZIPS = "zips";
    private static final int ZIPS_SIZE = 149;

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mapping = ImmutableMap.of((Object)"city", (Object)"keyword", (Object)"state", (Object)"keyword", (Object)"pop", (Object)"long");
        NODE.createIndex(ZIPS, (Map<String, String>)mapping);
        final ArrayList<ObjectNode> bulk = new ArrayList<ObjectNode>();
        Resources.readLines((URL)ElasticSearchAdapterTest.class.getResource("/zips-mini.json"), (Charset)StandardCharsets.UTF_8, (LineProcessor)new LineProcessor<Void>(){

            public boolean processLine(String line) throws IOException {
                line = line.replaceAll("_id", "id");
                bulk.add((ObjectNode)NODE.mapper().readTree(line));
                return true;
            }

            public Void getResult() {
                return null;
            }
        });
        if (bulk.isEmpty()) {
            throw new IllegalStateException("No records to index. Empty file ?");
        }
        NODE.insertBulk(ZIPS, bulk);
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:lex=JAVA");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), ElasticSearchAdapterTest.ZIPS));
                String viewSql = "select cast(_MAP['city'] AS varchar(20)) AS \"city\",  cast(_MAP['loc'][0] AS float) AS \"longitude\",\n cast(_MAP['loc'][1] AS float) AS \"latitude\",\n cast(_MAP['pop'] AS integer) AS \"pop\",  cast(_MAP['state'] AS varchar(2)) AS \"state\",  cast(_MAP['id'] AS varchar(5)) AS \"id\" from \"elastic\".\"zips\"";
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)"select cast(_MAP['city'] AS varchar(20)) AS \"city\",  cast(_MAP['loc'][0] AS float) AS \"longitude\",\n cast(_MAP['loc'][1] AS float) AS \"latitude\",\n cast(_MAP['pop'] AS integer) AS \"pop\",  cast(_MAP['state'] AS varchar(2)) AS \"state\",  cast(_MAP['id'] AS varchar(5)) AS \"id\" from \"elastic\".\"zips\"", Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add(ElasticSearchAdapterTest.ZIPS, (Function)macro);
                return connection;
            }
        };
    }

    private CalciteAssert.AssertThat calciteAssert() {
        return CalciteAssert.that().with(this.newConnectionFactory());
    }

    @Test
    public void view() {
        this.calciteAssert().query("select * from zips where city = 'BROOKLYN'").returns("city=BROOKLYN; longitude=-73.956985; latitude=40.646694; pop=111396; state=NY; id=11226\n").returnsCount(1);
    }

    @Test
    public void emptyResult() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from zips limit 0").returnsCount(0);
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips where _MAP['Foo'] = '_MISSING_'").returnsCount(0);
    }

    @Test
    public void basic() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips").runs();
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips where _MAP['city'] = 'BROOKLYN'").returnsCount(1);
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips where _MAP['city'] in ('BROOKLYN', 'WASHINGTON')").returnsCount(2);
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips where _MAP['city'] in ('brooklyn', 'Brooklyn', 'BROOK') ").returnsCount(0);
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips where _MAP['CITY'] = 'BROOKLYN'").returnsCount(0);
        CalciteAssert.that().with(this.newConnectionFactory()).query("select * from elastic.zips limit 0").returnsCount(0);
    }

    @Test
    public void testSort() {
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], dir0=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchTableScan(table=[[elastic, zips]])";
        Consumer<ResultSet> checker = rset -> {
            try {
                ArrayList<String> states = new ArrayList<String>();
                while (rset.next()) {
                    states.add(rset.getString("state"));
                }
                for (int i = 0; i < states.size() - 1; ++i) {
                    String next;
                    String current = (String)states.get(i);
                    if (current.compareTo(next = (String)states.get(i + 1)) <= 0) continue;
                    String message = String.format(Locale.ROOT, "Not sorted: %s (index:%d) > %s (index:%d) count: %d", current, i, next, i + 1, states.size());
                    throw new AssertionError((Object)message);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
        this.calciteAssert().query("select * from zips order by state").returnsCount(149).returns(checker).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], dir0=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchTableScan(table=[[elastic, zips]])");
    }

    @Test
    public void testSortLimit() {
        String sql = "select state, pop from zips\norder by state, pop offset 2 rows fetch next 3 rows only";
        this.calciteAssert().query("select state, pop from zips\norder by state, pop offset 2 rows fetch next 3 rows only").returnsUnordered(new String[]{"state=AK; pop=32383", "state=AL; pop=42124", "state=AL; pop=43862"}).queryContains(ElasticsearchChecker.elasticsearchChecker("'_source' : ['state', 'pop']", "sort: [ {state: 'asc'}, {pop: 'asc'}]", "from: 2", "size: 3"));
    }

    @Test
    public void sortAscDesc() {
        String sql = "select city, state, pop from zips\norder by pop desc, state asc, city desc limit 3";
        this.calciteAssert().query("select city, state, pop from zips\norder by pop desc, state asc, city desc limit 3").returnsOrdered(new String[]{"city=CHICAGO; state=IL; pop=112047", "city=BROOKLYN; state=NY; pop=111396", "city=NEW YORK; state=NY; pop=106564"}).queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':['city','state','pop']", "sort:[{pop:'desc'}, {state:'asc'}, {city:'desc'}]", "size:3"));
    }

    @Test
    public void testOffsetLimit() {
        String sql = "select state, id from zips\noffset 2 fetch next 3 rows only";
        this.calciteAssert().query("select state, id from zips\noffset 2 fetch next 3 rows only").runs().returnsCount(3).queryContains(ElasticsearchChecker.elasticsearchChecker("_source : ['state', 'id']", "from: 2", "size: 3"));
    }

    @Test
    public void testLimit() {
        String sql = "select state, id from zips\nfetch next 3 rows only";
        this.calciteAssert().query("select state, id from zips\nfetch next 3 rows only").runs().returnsCount(3).queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':['state','id']", "size:3"));
    }

    @Test
    public void limit2() {
        String sql = "select id from zips limit 5";
        this.calciteAssert().query("select id from zips limit 5").runs().returnsCount(5).queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':['id']", "size:5"));
    }

    @Test
    public void testFilterSort() {
        String sql = "select * from zips\nwhere state = 'CA' and pop >= 94000\norder by state, pop";
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], sort1=[$3], dir0=[ASC], dir1=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchFilter(condition=[AND(=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA'), >=(CAST(ITEM($0, 'pop')):INTEGER, 94000))])\n        ElasticsearchTableScan(table=[[elastic, zips]])\n\n";
        this.calciteAssert().query("select * from zips\nwhere state = 'CA' and pop >= 94000\norder by state, pop").returnsOrdered(new String[]{"city=NORWALK; longitude=-118.081767; latitude=33.90564; pop=94188; state=CA; id=90650", "city=LOS ANGELES; longitude=-118.258189; latitude=34.007856; pop=96074; state=CA; id=90011", "city=BELL GARDENS; longitude=-118.17205; latitude=33.969177; pop=99568; state=CA; id=90201"}).queryContains(ElasticsearchChecker.elasticsearchChecker("'query' : {'constant_score':{filter:{bool:{must:[{term:{state:'CA'}},{range:{pop:{gte:94000}}}]}}}}", "'script_fields': {longitude:{script:'params._source.loc[0]'}, latitude:{script:'params._source.loc[1]'}, city:{script: 'params._source.city'}, pop:{script: 'params._source.pop'}, state:{script: 'params._source.state'}, id:{script: 'params._source.id'}}", "sort: [ {state: 'asc'}, {pop: 'asc'}]", String.format(Locale.ROOT, "size:%s", 5196))).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchSort(sort0=[$4], sort1=[$3], dir0=[ASC], dir1=[ASC])\n    ElasticsearchProject(city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], longitude=[CAST(ITEM(ITEM($0, 'loc'), 0)):FLOAT], latitude=[CAST(ITEM(ITEM($0, 'loc'), 1)):FLOAT], pop=[CAST(ITEM($0, 'pop')):INTEGER], state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], id=[CAST(ITEM($0, 'id')):VARCHAR(5) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n      ElasticsearchFilter(condition=[AND(=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA'), >=(CAST(ITEM($0, 'pop')):INTEGER, 94000))])\n        ElasticsearchTableScan(table=[[elastic, zips]])\n\n");
    }

    @Test
    public void testFilterSortDesc() {
        String sql = "select * from zips\nwhere pop BETWEEN 95000 AND 100000\norder by state desc, pop";
        this.calciteAssert().query("select * from zips\nwhere pop BETWEEN 95000 AND 100000\norder by state desc, pop").limit(4).returnsOrdered(new String[]{"city=LOS ANGELES; longitude=-118.258189; latitude=34.007856; pop=96074; state=CA; id=90011", "city=BELL GARDENS; longitude=-118.17205; latitude=33.969177; pop=99568; state=CA; id=90201"});
    }

    @Test
    public void testInPlan() {
        String[] searches = new String[]{"query: {'constant_score':{filter:{bool:{should:[{term:{pop:96074}},{term:{pop:99568}}]}}}}", "script_fields: {longitude:{script:'params._source.loc[0]'}, latitude:{script:'params._source.loc[1]'}, city:{script: 'params._source.city'}, pop:{script: 'params._source.pop'}, state:{script: 'params._source.state'}, id:{script: 'params._source.id'}}", String.format(Locale.ROOT, "size:%d", 5196)};
        this.calciteAssert().query("select * from zips where pop in (96074, 99568)").returnsUnordered(new String[]{"city=BELL GARDENS; longitude=-118.17205; latitude=33.969177; pop=99568; state=CA; id=90201", "city=LOS ANGELES; longitude=-118.258189; latitude=34.007856; pop=96074; state=CA; id=90011"}).queryContains(ElasticsearchChecker.elasticsearchChecker(searches));
    }

    @Test
    public void testZips() {
        this.calciteAssert().query("select state, city from zips").returnsCount(149);
    }

    @Test
    public void testProject() {
        String sql = "select state, city, 0 as zero\nfrom zips\norder by state, city";
        this.calciteAssert().query("select state, city, 0 as zero\nfrom zips\norder by state, city").limit(2).returnsUnordered(new String[]{"state=AK; city=ANCHORAGE; zero=0", "state=AK; city=FAIRBANKS; zero=0"}).queryContains(ElasticsearchChecker.elasticsearchChecker("script_fields:{zero:{script:'0'},state:{script:'params._source.state'},city:{script:'params._source.city'}}", "sort:[{state:'asc'},{city:'asc'}]", String.format(Locale.ROOT, "size:%d", 5196)));
    }

    @Test
    public void testFilter() {
        String explain = "PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchProject(state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n    ElasticsearchFilter(condition=[=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA')])\n      ElasticsearchTableScan(table=[[elastic, zips]])";
        this.calciteAssert().query("select state, city from zips where state = 'CA'").limit(3).returnsUnordered(new String[]{"state=CA; city=BELL GARDENS", "state=CA; city=LOS ANGELES", "state=CA; city=NORWALK"}).explainContains("PLAN=ElasticsearchToEnumerableConverter\n  ElasticsearchProject(state=[CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], city=[CAST(ITEM($0, 'city')):VARCHAR(20) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"])\n    ElasticsearchFilter(condition=[=(CAST(ITEM($0, 'state')):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'CA')])\n      ElasticsearchTableScan(table=[[elastic, zips]])");
    }

    @Test
    public void testFilterReversed() {
        this.calciteAssert().query("select state, city from zips where 'WI' < state order by city").limit(2).returnsUnordered(new String[]{"state=WV; city=BECKLEY", "state=WY; city=CHEYENNE"});
        this.calciteAssert().query("select state, city from zips where state > 'WI' order by city").limit(2).returnsUnordered(new String[]{"state=WV; city=BECKLEY", "state=WY; city=CHEYENNE"});
    }

    @Test
    public void agg1() {
        this.calciteAssert().query("select count(*) from zips").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0")).returns("EXPR$0=149\n");
        this.calciteAssert().query("select count(*) from zips limit 1").returns("EXPR$0=149\n");
        this.calciteAssert().query("select count(*) as cnt from zips").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0")).returns("cnt=149\n");
        this.calciteAssert().query("select min(pop), max(pop) from zips").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'EXPR$0':{min:{field:'pop'}},'EXPR$1':{max:{field:'pop'}}}")).returns("EXPR$0=21; EXPR$1=112047\n");
        this.calciteAssert().query("select min(pop) as min1, max(pop) as max1 from zips").returns("min1=21; max1=112047\n");
        this.calciteAssert().query("select count(*), max(pop), min(pop), sum(pop), avg(pop) from zips").returns("EXPR$0=149; EXPR$1=112047; EXPR$2=21; EXPR$3=7865489; EXPR$4=52788\n");
    }

    @Test
    public void groupBy() {
        this.calciteAssert().query("select distinct state\nfrom zips\nlimit 6").queryContains(ElasticsearchChecker.elasticsearchChecker("_source:false", "size:0", "aggregations:{'g_state':{'terms':{'field':'state','missing':'__MISSING__', 'size' : 6}}}")).returnsOrdered(new String[]{"state=AK", "state=AL", "state=AR", "state=AZ", "state=CA", "state=CO"});
        this.calciteAssert().query("select state, city\nfrom zips\ngroup by state, city\norder by city limit 10").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_city':{'terms':{'field':'city','missing':'__MISSING__','size':10,'order':{'_key':'asc'}}", "aggregations:{'g_state':{'terms':{'field':'state','missing':'__MISSING__','size':10}}}}}}")).returnsOrdered(new String[]{"state=SD; city=ABERDEEN", "state=SC; city=AIKEN", "state=TX; city=ALTON", "state=IA; city=AMES", "state=AK; city=ANCHORAGE", "state=MD; city=BALTIMORE", "state=ME; city=BANGOR", "state=KS; city=BAVARIA", "state=NJ; city=BAYONNE", "state=OR; city=BEAVERTON"});
        this.calciteAssert().query("select min(pop), max(pop), state\nfrom zips\ngroup by state\norder by state limit 3").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_state':{terms:{field:'state',missing:'__MISSING__',size:3, order:{'_key':'asc'}}", "aggregations:{'EXPR$0':{min:{field:'pop'}},'EXPR$1':{max:{field:'pop'}}}}}")).returnsOrdered(new String[]{"EXPR$0=23238; EXPR$1=32383; state=AK", "EXPR$0=42124; EXPR$1=44165; state=AL", "EXPR$0=37428; EXPR$1=53532; state=AR"});
        this.calciteAssert().query("select min(pop), state\nfrom zips\ngroup by state\norder by state limit 3").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_state':{terms:{field:'state',missing:'__MISSING__',size:3, order:{'_key':'asc'}}", "aggregations:{'EXPR$0':{min:{field:'pop'}} }}}")).returnsOrdered(new String[]{"EXPR$0=23238; state=AK", "EXPR$0=42124; state=AL", "EXPR$0=37428; state=AR"});
        this.calciteAssert().query("select count(city), state\nfrom zips\ngroup by state\norder by state limit 3").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_state':{terms:{field:'state',missing:'__MISSING__', size:3, order:{'_key':'asc'}}", "aggregations:{'EXPR$0':{'value_count':{field:'city'}} }}}")).returnsOrdered(new String[]{"EXPR$0=3; state=AK", "EXPR$0=3; state=AL", "EXPR$0=3; state=AR"});
        this.calciteAssert().query("select min(pop), max(pop), state\nfrom zips\ngroup by state\norder by state desc limit 3").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_state':{terms:{field:'state',missing:'__MISSING__',size:3, order:{'_key':'desc'}}", "aggregations:{'EXPR$0':{min:{field:'pop'}},'EXPR$1':{max:{field:'pop'}}}}}")).returnsOrdered(new String[]{"EXPR$0=25968; EXPR$1=33107; state=WY", "EXPR$0=45196; EXPR$1=70185; state=WV", "EXPR$0=51008; EXPR$1=57187; state=WI"});
    }

    @Test
    public void notOperator() {
        this.calciteAssert().query("select count(*), max(pop) from zips where state not in ('IL')").returns("EXPR$0=146; EXPR$1=111396\n");
        this.calciteAssert().query("select count(*), max(pop) from zips where not state in ('IL')").returns("EXPR$0=146; EXPR$1=111396\n");
        this.calciteAssert().query("select count(*), max(pop) from zips where not state not in ('IL')").returns("EXPR$0=3; EXPR$1=112047\n");
        this.calciteAssert().query("select count(*), max(pop) from zips where state not in ('IL', 'NY')").returns("EXPR$0=143; EXPR$1=99568\n");
        this.calciteAssert().query("select count(*), max(pop) from zips where state not in ('IL', 'NY', 'CA')").returns("EXPR$0=140; EXPR$1=84712\n");
    }

    @Test
    @Ignore
    public void approximateCount() throws Exception {
        this.calciteAssert().query("select approx_count_distinct(city), state from zips group by state order by state limit 3").queryContains(ElasticsearchChecker.elasticsearchChecker("'_source':false", "size:0", "aggregations:{'g_state':{terms:{field:state, size:3, order:{'_key':'asc'}}", "aggregations:{'EXPR$0':{cardinality:{field:city}} }}}")).returnsOrdered(new String[]{"EXPR$0=3; state=AK", "EXPR$0=3; state=AL", "EXPR$0=3; state=AR"});
    }
}

