/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class BooleanLogicTest {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String NAME = "docs";

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mapping = ImmutableMap.of((Object)"a", (Object)"keyword", (Object)"b", (Object)"keyword", (Object)"c", (Object)"keyword", (Object)"int", (Object)"long");
        NODE.createIndex(NAME, (Map<String, String>)mapping);
        String doc = "{'a': 'a', 'b':'b', 'c':'c', 'int': 42}".replace('\'', '\"');
        NODE.insertDocument(NAME, (ObjectNode)NODE.mapper().readTree(doc));
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), BooleanLogicTest.NAME));
                String viewSql = String.format(Locale.ROOT, "select cast(_MAP['a'] AS varchar(2)) AS a,  cast(_MAP['b'] AS varchar(2)) AS b,  cast(_MAP['c'] AS varchar(2)) AS c,  cast(_MAP['int'] AS integer) AS num from \"elastic\".\"%s\"", BooleanLogicTest.NAME);
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)viewSql, Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add("VIEW", (Function)macro);
                return connection;
            }
        };
    }

    @Test
    public void expressions() {
        this.assertSingle("select * from view");
        this.assertSingle("select * from view where a = 'a'");
        this.assertEmpty("select * from view where a <> 'a'");
        this.assertSingle("select * from view where  'a' = a");
        this.assertEmpty("select * from view where a = 'b'");
        this.assertEmpty("select * from view where 'b' = a");
        this.assertSingle("select * from view where a in ('a', 'b')");
        this.assertSingle("select * from view where a in ('a', 'c') and b = 'b'");
        this.assertSingle("select * from view where (a = 'ZZ' or a = 'a')  and b = 'b'");
        this.assertSingle("select * from view where b = 'b' and a in ('a', 'c')");
        this.assertSingle("select * from view where num = 42 and a in ('a', 'c')");
        this.assertEmpty("select * from view where a in ('a', 'c') and b = 'c'");
        this.assertSingle("select * from view where a in ('a', 'c') and b = 'b' and num = 42");
        this.assertSingle("select * from view where a in ('a', 'c') and b = 'b' and num >= 42");
        this.assertEmpty("select * from view where a in ('a', 'c') and b = 'b' and num <> 42");
        this.assertEmpty("select * from view where a in ('a', 'c') and b = 'b' and num > 42");
        this.assertSingle("select * from view where num = 42");
        this.assertSingle("select * from view where 42 = num");
        this.assertEmpty("select * from view where num > 42");
        this.assertEmpty("select * from view where 42 > num");
        this.assertEmpty("select * from view where num > 42 and num > 42");
        this.assertEmpty("select * from view where num > 42 and num < 42");
        this.assertEmpty("select * from view where num > 42 and num < 42 and num <> 42");
        this.assertEmpty("select * from view where num > 42 and num < 42 and num = 42");
        this.assertEmpty("select * from view where num > 42 or num < 42 and num = 42");
        this.assertSingle("select * from view where num > 42 and num < 42 or num = 42");
        this.assertSingle("select * from view where num > 42 or num < 42 or num = 42");
        this.assertSingle("select * from view where num >= 42 and num <= 42 and num = 42");
        this.assertEmpty("select * from view where num >= 42 and num <= 42 and num <> 42");
        this.assertEmpty("select * from view where num < 42");
        this.assertEmpty("select * from view where num <> 42");
        this.assertSingle("select * from view where num >= 42");
        this.assertSingle("select * from view where num <= 42");
        this.assertSingle("select * from view where num < 43");
        this.assertSingle("select * from view where num < 50");
        this.assertSingle("select * from view where num > 41");
        this.assertSingle("select * from view where num > 0");
        this.assertSingle("select * from view where (a = 'a' and b = 'b') or (num = 42 and c = 'c')");
        this.assertSingle("select * from view where c = 'c' and (a in ('a', 'b') or num in (41, 42))");
        this.assertSingle("select * from view where (a = 'a' or b = 'b') or (num = 42 and c = 'c')");
        this.assertSingle("select * from view where a = 'a' and (b = '0' or (b = 'b' and (c = '0' or (c = 'c' and num = 42))))");
    }

    @Test
    public void notExpression() {
        this.assertEmpty("select * from view where not a = 'a'");
        this.assertSingle("select * from view where not not a = 'a'");
        this.assertEmpty("select * from view where not not not a = 'a'");
        this.assertSingle("select * from view where not a <> 'a'");
        this.assertSingle("select * from view where not not not a <> 'a'");
        this.assertEmpty("select * from view where not 'a' = a");
        this.assertSingle("select * from view where not 'a' <> a");
        this.assertSingle("select * from view where not a = 'b'");
        this.assertSingle("select * from view where not 'b' = a");
        this.assertEmpty("select * from view where not a in ('a')");
        this.assertEmpty("select * from view where a not in ('a')");
        this.assertSingle("select * from view where not a not in ('a')");
        this.assertEmpty("select * from view where not a not in ('b')");
        this.assertEmpty("select * from view where not not a not in ('a')");
        this.assertSingle("select * from view where not not a not in ('b')");
        this.assertEmpty("select * from view where not a in ('a', 'b')");
        this.assertEmpty("select * from view where a not in ('a', 'b')");
        this.assertEmpty("select * from view where not a not in ('z')");
        this.assertEmpty("select * from view where not a not in ('z')");
        this.assertSingle("select * from view where not a in ('z')");
        this.assertSingle("select * from view where not (not num = 42 or not a in ('a', 'c'))");
        this.assertEmpty("select * from view where not num > 0");
        this.assertEmpty("select * from view where num = 42 and a not in ('a', 'c')");
        this.assertSingle("select * from view where not (num > 42 or num < 42 and num = 42)");
    }

    private void assertSingle(String query) {
        CalciteAssert.that().with(this.newConnectionFactory()).query(query).returns("A=a; B=b; C=c; NUM=42\n");
    }

    private void assertEmpty(String query) {
        CalciteAssert.that().with(this.newConnectionFactory()).query(query).returns("");
    }
}

