/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchEnumerator;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTableScan;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final Client client;
    private final String indexName;
    private final String typeName;

    public ElasticsearchTable(Client client, String indexName, String typeName) {
        super(Object[].class);
        this.client = client;
        this.indexName = indexName;
        this.typeName = typeName;
    }

    public String toString() {
        return "ElasticsearchTable{" + this.typeName + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        RelDataType mapType = relDataTypeFactory.createMapType(relDataTypeFactory.createSqlType(SqlTypeName.VARCHAR), relDataTypeFactory.createTypeWithNullability(relDataTypeFactory.createSqlType(SqlTypeName.ANY), true));
        return relDataTypeFactory.builder().add("_MAP", mapType).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ElasticsearchQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new ElasticsearchTableScan(cluster, cluster.traitSetOf((RelTrait)ElasticsearchRel.CONVENTION), relOptTable, this, null);
    }

    private Enumerable<Object> find(String index, List<String> ops, List<Map.Entry<String, Class>> fields) {
        final String dbName = index;
        final String queryString = "{" + Util.toString(ops, (String)"", (String)", ", (String)"") + "}";
        final Function1<SearchHit, Object> getter = ElasticsearchEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                Iterator cursor = ((SearchResponse)ElasticsearchTable.this.client.prepareSearch(new String[]{dbName}).setTypes(new String[]{ElasticsearchTable.this.typeName}).setSource(queryString).execute().actionGet()).getHits().iterator();
                return new ElasticsearchEnumerator(cursor, (Function1<SearchHit, Object>)getter);
            }
        };
    }

    public static class ElasticsearchQueryable<T>
    extends AbstractTableQueryable<T> {
        public ElasticsearchQueryable(QueryProvider queryProvider, SchemaPlus schema, ElasticsearchTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            return null;
        }

        private String getIndex() {
            return ((ElasticsearchSchema)((Object)this.schema.unwrap(ElasticsearchSchema.class))).index;
        }

        private ElasticsearchTable getTable() {
            return (ElasticsearchTable)this.table;
        }

        public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields) {
            return this.getTable().find(this.getIndex(), ops, fields);
        }
    }
}

