/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ElasticsearchSchema
extends AbstractSchema {
    final String index;
    private transient Client client;

    ElasticsearchSchema(Map<String, Integer> coordinates, Map<String, String> userConfig, String indexName) {
        String[] indices;
        ArrayList<InetSocketAddress> transportAddresses = new ArrayList<InetSocketAddress>();
        for (Map.Entry<String, Integer> coordinate : coordinates.entrySet()) {
            transportAddresses.add(new InetSocketAddress(coordinate.getKey(), (int)coordinate.getValue()));
        }
        this.open(transportAddresses, userConfig);
        this.index = this.client != null ? ((indices = ((GetIndexResponse)this.client.admin().indices().getIndex((GetIndexRequest)new GetIndexRequest().indices(new String[]{indexName})).actionGet()).getIndices()).length == 1 ? indices[0] : null) : null;
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            GetMappingsResponse response = (GetMappingsResponse)this.client.admin().indices().getMappings((GetMappingsRequest)new GetMappingsRequest().indices(new String[]{this.index})).get();
            ImmutableOpenMap mapping = (ImmutableOpenMap)response.getMappings().get((Object)this.index);
            for (ObjectObjectCursor c : mapping) {
                builder.put(c.key, (Object)new ElasticsearchTable(this.client, this.index, (String)c.key));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    private void open(List<InetSocketAddress> transportAddresses, Map<String, String> userConfig) {
        ArrayList<InetSocketTransportAddress> transportNodes = new ArrayList<InetSocketTransportAddress>(transportAddresses.size());
        for (InetSocketAddress address : transportAddresses) {
            transportNodes.add(new InetSocketTransportAddress(address));
        }
        Settings settings = Settings.settingsBuilder().put(userConfig).build();
        TransportClient transportClient = TransportClient.builder().settings(settings).build();
        for (TransportAddress transportAddress : transportNodes) {
            transportClient.addTransportAddress(transportAddress);
        }
        ImmutableList nodes = ImmutableList.copyOf((Collection)transportClient.connectedNodes());
        if (nodes.isEmpty()) {
            throw new RuntimeException("Cannot connect to any elasticsearch nodes");
        }
        this.client = transportClient;
    }
}

