/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;

public class CassandraSort
extends Sort
implements CassandraRel {
    private final RelCollation implicitCollation;

    public CassandraSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RelCollation implicitCollation, RexNode fetch) {
        super(cluster, traitSet, child, collation, null, fetch);
        this.implicitCollation = implicitCollation;
        assert (this.getConvention() == CassandraRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new CassandraSort(this.getCluster(), traitSet, input, this.collation, this.implicitCollation, fetch);
    }

    @Override
    public void implement(CassandraRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List sortCollations = this.collation.getFieldCollations();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        if (!sortCollations.isEmpty()) {
            List fields = this.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : sortCollations) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                String direction = "ASC";
                if (fieldCollation.getDirection().equals((Object)RelFieldCollation.Direction.DESCENDING)) {
                    direction = "DESC";
                }
                fieldOrder.add(name + " " + direction);
            }
            implementor.addOrder(fieldOrder);
        }
        if (this.fetch != null) {
            implementor.setLimit(((RexLiteral)this.fetch).getValue().toString());
        }
    }
}

