/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.cassandra.CassandraFilter;
import org.apache.calcite.adapter.cassandra.CassandraProject;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraSort;
import org.apache.calcite.adapter.cassandra.CassandraTableScan;
import org.apache.calcite.adapter.cassandra.CassandraToEnumerableConverter;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;

public class CassandraRules {
    public static final RelOptRule[] RULES = new RelOptRule[]{CassandraFilterRule.access$000(), CassandraProjectRule.access$100(), CassandraSortRule.access$200()};

    private CassandraRules() {
    }

    static List<String> cassandraFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        });
    }

    private static class CassandraSortRule
    extends RelOptRule {
        private static final Predicate<Sort> SORT_PREDICATE = new Predicate<Sort>(){

            public boolean apply(Sort input) {
                return input.offset == null;
            }
        };
        private static final Predicate<CassandraFilter> FILTER_PREDICATE = new Predicate<CassandraFilter>(){

            public boolean apply(CassandraFilter input) {
                return input.isSinglePartition();
            }
        };
        private static final RelOptRuleOperand CASSANDRA_OP = CassandraSortRule.operand(CassandraToEnumerableConverter.class, (RelOptRuleOperand)CassandraSortRule.operand(CassandraFilter.class, null, FILTER_PREDICATE, (RelOptRuleOperandChildren)CassandraSortRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]);
        private static final CassandraSortRule INSTANCE = new CassandraSortRule();

        private CassandraSortRule() {
            super(CassandraSortRule.operand(Sort.class, null, SORT_PREDICATE, (RelOptRuleOperand)CASSANDRA_OP, (RelOptRuleOperand[])new RelOptRuleOperand[0]), "CassandraSortRule");
        }

        public RelNode convert(Sort sort, CassandraFilter filter) {
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)CassandraRel.CONVENTION).replace((RelTrait)sort.getCollation());
            return new CassandraSort(sort.getCluster(), traitSet, CassandraSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), filter.getImplicitCollation(), sort.fetch);
        }

        public boolean matches(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            CassandraFilter filter = (CassandraFilter)call.rel(2);
            return this.collationsCompatible(sort.getCollation(), filter.getImplicitCollation());
        }

        private boolean collationsCompatible(RelCollation sortCollation, RelCollation implicitCollation) {
            List sortFieldCollations = sortCollation.getFieldCollations();
            List implicitFieldCollations = implicitCollation.getFieldCollations();
            if (sortFieldCollations.size() > implicitFieldCollations.size()) {
                return false;
            }
            if (sortFieldCollations.size() == 0) {
                return true;
            }
            boolean reversed = this.reverseDirection(((RelFieldCollation)sortFieldCollations.get(0)).getDirection()) == ((RelFieldCollation)implicitFieldCollations.get(0)).getDirection();
            for (int i = 0; i < sortFieldCollations.size(); ++i) {
                RelFieldCollation sorted = (RelFieldCollation)sortFieldCollations.get(i);
                RelFieldCollation implied = (RelFieldCollation)implicitFieldCollations.get(i);
                if (sorted.getFieldIndex() != implied.getFieldIndex()) {
                    return false;
                }
                RelFieldCollation.Direction sortDirection = sorted.getDirection();
                RelFieldCollation.Direction implicitDirection = implied.getDirection();
                if ((reversed || sortDirection == implicitDirection) && (!reversed || this.reverseDirection(sortDirection) == implicitDirection)) continue;
                return false;
            }
            return true;
        }

        private RelFieldCollation.Direction reverseDirection(RelFieldCollation.Direction direction) {
            switch (direction) {
                case ASCENDING: 
                case STRICTLY_ASCENDING: {
                    return RelFieldCollation.Direction.DESCENDING;
                }
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    return RelFieldCollation.Direction.ASCENDING;
                }
            }
            return null;
        }

        public void onMatch(RelOptRuleCall call) {
            CassandraFilter filter;
            Sort sort = (Sort)call.rel(0);
            RelNode converted = this.convert(sort, filter = (CassandraFilter)call.rel(2));
            if (converted != null) {
                call.transformTo(converted);
            }
        }

        static /* synthetic */ CassandraSortRule access$200() {
            return INSTANCE;
        }
    }

    private static class CassandraProjectRule
    extends CassandraConverterRule {
        private static final CassandraProjectRule INSTANCE = new CassandraProjectRule();

        private CassandraProjectRule() {
            super(LogicalProject.class, "CassandraProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new CassandraProject(project.getCluster(), traitSet, CassandraProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ CassandraProjectRule access$100() {
            return INSTANCE;
        }
    }

    private static class CassandraFilterRule
    extends RelOptRule {
        private static final Predicate<LogicalFilter> PREDICATE = new Predicate<LogicalFilter>(){

            public boolean apply(LogicalFilter input) {
                return RelOptUtil.disjunctions((RexNode)input.getCondition()).size() == 1;
            }
        };
        private static final CassandraFilterRule INSTANCE = new CassandraFilterRule();

        private CassandraFilterRule() {
            super(CassandraFilterRule.operand(LogicalFilter.class, (RelOptRuleOperand)CassandraFilterRule.operand(CassandraTableScan.class, (RelOptRuleOperandChildren)CassandraFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "CassandraFilterRule");
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            RexNode condition = filter.getCondition();
            CassandraTableScan scan = (CassandraTableScan)call.rel(1);
            Pair<List<String>, List<String>> keyFields = scan.cassandraTable.getKeyFields();
            HashSet<String> partitionKeys = new HashSet<String>((Collection)keyFields.left);
            List<String> fieldNames = CassandraRules.cassandraFieldNames(filter.getInput().getRowType());
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
            if (disjunctions.size() != 1) {
                return false;
            }
            condition = (RexNode)disjunctions.get(0);
            for (RexNode predicate : RelOptUtil.conjunctions((RexNode)condition)) {
                if (this.isEqualityOnKey(predicate, fieldNames, partitionKeys, (List)keyFields.right)) continue;
                return false;
            }
            return partitionKeys.size() == ((List)keyFields.left).size() || partitionKeys.size() == 0;
        }

        private boolean isEqualityOnKey(RexNode node, List<String> fieldNames, Set<String> partitionKeys, List<String> clusteringKeys) {
            RexNode right;
            if (node.getKind() != SqlKind.EQUALS) {
                return false;
            }
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.operands.get(0);
            String key = this.compareFieldWithLiteral(left, right = (RexNode)call.operands.get(1), fieldNames);
            if (key == null) {
                key = this.compareFieldWithLiteral(right, left, fieldNames);
            }
            if (key != null) {
                return partitionKeys.remove(key) || clusteringKeys.contains(key);
            }
            return false;
        }

        private String compareFieldWithLiteral(RexNode left, RexNode right, List<String> fieldNames) {
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).getOperands().get(0);
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.LITERAL)) {
                RexInputRef left1 = (RexInputRef)left;
                String name = fieldNames.get(left1.getIndex());
                return name;
            }
            return null;
        }

        public void onMatch(RelOptRuleCall call) {
            RelNode converted;
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            CassandraTableScan scan = (CassandraTableScan)call.rel(1);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE) && (converted = this.convert(filter, scan)) != null) {
                call.transformTo(converted);
            }
        }

        public RelNode convert(LogicalFilter filter, CassandraTableScan scan) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)CassandraRel.CONVENTION);
            Pair<List<String>, List<String>> keyFields = scan.cassandraTable.getKeyFields();
            return new CassandraFilter(filter.getCluster(), traitSet, CassandraFilterRule.convert((RelNode)filter.getInput(), (RelTrait)CassandraRel.CONVENTION), filter.getCondition(), (List)keyFields.left, (List)keyFields.right, scan.cassandraTable.getClusteringOrder());
        }

        static /* synthetic */ CassandraFilterRule access$000() {
            return INSTANCE;
        }
    }

    static abstract class CassandraConverterRule
    extends ConverterRule {
        protected final Convention out = CassandraRel.CONVENTION;

        public CassandraConverterRule(Class<? extends RelNode> clazz, String description) {
            this(clazz, Predicates.alwaysTrue(), description);
        }

        public <R extends RelNode> CassandraConverterRule(Class<R> clazz, Predicate<? super R> predicate, String description) {
            super(clazz, predicate, (RelTrait)Convention.NONE, (RelTrait)CassandraRel.CONVENTION, description);
        }
    }

    static class RexToCassandraTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        protected RexToCassandraTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }
    }
}

