/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;

public interface CassandraRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("CASSANDRA", CassandraRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        final List<String> selectFields = new ArrayList<String>();
        final List<String> whereClause = new ArrayList<String>();
        String limitValue = null;
        final List<String> order = new ArrayList<String>();
        RelOptTable table;
        CassandraTable cassandraTable;

        public void add(List<String> fields, List<String> predicates) {
            if (fields != null) {
                this.selectFields.addAll(fields);
            }
            if (predicates != null) {
                this.whereClause.addAll(predicates);
            }
        }

        public void addOrder(List<String> newOrder) {
            this.order.addAll(newOrder);
        }

        public void setLimit(String limit) {
            this.limitValue = limit;
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((CassandraRel)input).implement(this);
        }
    }
}

