/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;

class CassandraEnumerator
implements Enumerator<Object> {
    private Iterator<Row> iterator;
    private Row current;
    private List<RelDataTypeField> fieldTypes;

    public CassandraEnumerator(ResultSet results, RelProtoDataType protoRowType) {
        this.iterator = results.iterator();
        this.current = null;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.fieldTypes = ((RelDataType)protoRowType.apply((Object)typeFactory)).getFieldList();
    }

    public Object current() {
        if (this.fieldTypes.size() == 1) {
            return this.currentRowField(0, this.fieldTypes.get(0).getType().getSqlTypeName());
        }
        Object[] row = new Object[this.fieldTypes.size()];
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            row[i] = this.currentRowField(i, this.fieldTypes.get(i).getType().getSqlTypeName());
        }
        return row;
    }

    private Object currentRowField(int index, SqlTypeName typeName) {
        DataType type = this.current.getColumnDefinitions().getType(index);
        if (type == DataType.ascii() || type == DataType.text() || type == DataType.varchar()) {
            return this.current.getString(index);
        }
        if (type == DataType.cint() || type == DataType.varint()) {
            return this.current.getInt(index);
        }
        if (type == DataType.bigint()) {
            return this.current.getLong(index);
        }
        if (type == DataType.cdouble() || type == DataType.cfloat()) {
            return this.current.getDouble(index);
        }
        if (type == DataType.uuid() || type == DataType.timeuuid()) {
            return this.current.getUUID(index).toString();
        }
        return null;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

