/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraRules;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.adapter.cassandra.CassandraToEnumerableConverterRule;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;

public class CassandraTableScan
extends TableScan
implements CassandraRel {
    final CassandraTable cassandraTable;
    final RelDataType projectRowType;

    protected CassandraTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, CassandraTable cassandraTable, RelDataType projectRowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        this.cassandraTable = cassandraTable;
        this.projectRowType = projectRowType;
        assert (cassandraTable != null);
        assert (this.getConvention() == CassandraRel.CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)CassandraToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : CassandraRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(CassandraRel.Implementor implementor) {
        implementor.cassandraTable = this.cassandraTable;
        implementor.table = this.table;
    }
}

