/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class CassandraSchema
extends AbstractSchema {
    final Session session;
    final String keyspace;
    private final SchemaPlus parentSchema;
    final String name;
    final Hook.Closeable hook;
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    public CassandraSchema(String host, String keyspace, SchemaPlus parentSchema, String name) {
        this(host, keyspace, null, null, parentSchema, name);
    }

    public CassandraSchema(String host, String keyspace, String username, String password, SchemaPlus parentSchema, String name) {
        this.keyspace = keyspace;
        try {
            Cluster cluster = username != null && password != null ? Cluster.builder().addContactPoint(host).withCredentials(username, password).build() : Cluster.builder().addContactPoint(host).build();
            this.session = cluster.connect(keyspace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parentSchema = parentSchema;
        this.name = name;
        this.hook = Hook.TRIMMED.add((Function)new Function<RelNode, Void>(){

            public Void apply(RelNode node) {
                CassandraSchema.this.addMaterializedViews();
                return null;
            }
        });
    }

    RelProtoDataType getRelDataType(String columnFamily, boolean view) {
        List columns = view ? this.getKeyspace().getMaterializedView(columnFamily).getColumns() : this.getKeyspace().getTable(columnFamily).getColumns();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (ColumnMetadata column : columns) {
            String columnName = column.getName();
            DataType type = column.getType();
            SqlTypeName typeName = SqlTypeName.ANY;
            if (type == DataType.uuid() || type == DataType.timeuuid()) {
                typeName = SqlTypeName.CHAR;
            } else if (type == DataType.ascii() || type == DataType.text() || type == DataType.varchar()) {
                typeName = SqlTypeName.VARCHAR;
            } else if (type == DataType.cint() || type == DataType.varint()) {
                typeName = SqlTypeName.INTEGER;
            } else if (type == DataType.bigint()) {
                typeName = SqlTypeName.BIGINT;
            } else if (type == DataType.cdouble() || type == DataType.cfloat() || type == DataType.decimal()) {
                typeName = SqlTypeName.DOUBLE;
            }
            fieldInfo.add(columnName, typeFactory.createSqlType(typeName)).nullable(true);
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    Pair<List<String>, List<String>> getKeyFields(String columnFamily, boolean view) {
        Object table = view ? this.getKeyspace().getMaterializedView(columnFamily) : this.getKeyspace().getTable(columnFamily);
        List partitionKey = table.getPartitionKey();
        ArrayList<String> pKeyFields = new ArrayList<String>();
        for (ColumnMetadata column : partitionKey) {
            pKeyFields.add(column.getName());
        }
        List clusteringKey = table.getClusteringColumns();
        ArrayList<String> cKeyFields = new ArrayList<String>();
        for (ColumnMetadata column : clusteringKey) {
            cKeyFields.add(column.getName());
        }
        return Pair.of((Object)ImmutableList.copyOf(pKeyFields), (Object)ImmutableList.copyOf(cKeyFields));
    }

    public List<RelFieldCollation> getClusteringOrder(String columnFamily, boolean view) {
        Object table = view ? this.getKeyspace().getMaterializedView(columnFamily) : this.getKeyspace().getTable(columnFamily);
        List clusteringOrder = table.getClusteringOrder();
        ArrayList<RelFieldCollation> keyCollations = new ArrayList<RelFieldCollation>();
        int i = 0;
        for (ClusteringOrder order : clusteringOrder) {
            RelFieldCollation.Direction direction;
            switch (order) {
                case DESC: {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    break;
                }
                default: {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
            }
            keyCollations.add(new RelFieldCollation(i, direction));
            ++i;
        }
        return keyCollations;
    }

    private void addMaterializedViews() {
        this.hook.close();
        for (MaterializedViewMetadata view : this.getKeyspace().getMaterializedViews()) {
            SqlSelect parsedQuery;
            String tableName = view.getBaseTable().getName();
            StringBuilder queryBuilder = new StringBuilder("SELECT ");
            ArrayList<String> columnNames = new ArrayList<String>();
            for (ColumnMetadata column : view.getColumns()) {
                columnNames.add("\"" + column.getName() + "\"");
            }
            queryBuilder.append(Util.toString(columnNames, (String)"", (String)", ", (String)""));
            queryBuilder.append(" FROM \"" + tableName + "\"");
            String whereQuery = "SELECT where_clause from system_schema.views WHERE keyspace_name='" + this.keyspace + "' AND view_name='" + view.getName() + "'";
            queryBuilder.append(" WHERE " + this.session.execute(whereQuery).one().getString(0));
            String query = queryBuilder.toString();
            SqlParser.ConfigBuilder configBuilder = SqlParser.configBuilder();
            configBuilder.setUnquotedCasing(Casing.UNCHANGED);
            try {
                parsedQuery = (SqlSelect)SqlParser.create((String)query, (SqlParser.Config)configBuilder.build()).parseQuery();
            }
            catch (SqlParseException e) {
                LOGGER.warn("Could not parse query {} for CQL view {}.{}", new Object[]{query, this.keyspace, view.getName()});
                continue;
            }
            StringWriter stringWriter = new StringWriter(query.length());
            PrintWriter printWriter = new PrintWriter(stringWriter);
            SqlPrettyWriter writer = new SqlPrettyWriter(SqlDialect.CALCITE, true, printWriter);
            parsedQuery.unparse((SqlWriter)writer, 0, 0);
            query = stringWriter.toString();
            String viewName = "$" + this.getTableNames().size();
            SchemaPlus schema = this.parentSchema.getSubSchema(this.name);
            CalciteSchema calciteSchema = CalciteSchema.from((SchemaPlus)schema);
            List viewPath = calciteSchema.path(viewName);
            schema.add(viewName, (org.apache.calcite.schema.Function)MaterializedViewTable.create((CalciteSchema)calciteSchema, (String)query, null, (List)viewPath, (String)view.getName(), (boolean)true));
        }
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableMetadata table : this.getKeyspace().getTables()) {
            String tableName = table.getName();
            builder.put((Object)tableName, (Object)new CassandraTable(this, tableName));
            for (MaterializedViewMetadata view : table.getViews()) {
                String viewName = view.getName();
                builder.put((Object)viewName, (Object)new CassandraTable(this, viewName, true));
            }
        }
        return builder.build();
    }

    private KeyspaceMetadata getKeyspace() {
        return this.session.getCluster().getMetadata().getKeyspace(this.keyspace);
    }
}

