/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.cassandra.CassandraEnumerator;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.adapter.cassandra.CassandraTableScan;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class CassandraTable
extends AbstractQueryableTable
implements TranslatableTable {
    RelProtoDataType protoRowType;
    Pair<List<String>, List<String>> keyFields;
    List<RelFieldCollation> clusteringOrder;
    private final CassandraSchema schema;
    private final String columnFamily;
    private final boolean view;

    public CassandraTable(CassandraSchema schema, String columnFamily, boolean view) {
        super(Object[].class);
        this.schema = schema;
        this.columnFamily = columnFamily;
        this.view = view;
    }

    public CassandraTable(CassandraSchema schema, String columnFamily) {
        this(schema, columnFamily, false);
    }

    public String toString() {
        return "CassandraTable {" + this.columnFamily + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType == null) {
            this.protoRowType = this.schema.getRelDataType(this.columnFamily, this.view);
        }
        return (RelDataType)this.protoRowType.apply((Object)typeFactory);
    }

    public Pair<List<String>, List<String>> getKeyFields() {
        if (this.keyFields == null) {
            this.keyFields = this.schema.getKeyFields(this.columnFamily, this.view);
        }
        return this.keyFields;
    }

    public List<RelFieldCollation> getClusteringOrder() {
        if (this.clusteringOrder == null) {
            this.clusteringOrder = this.schema.getClusteringOrder(this.columnFamily, this.view);
        }
        return this.clusteringOrder;
    }

    public Enumerable<Object> query(Session session) {
        return this.query(session, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0, -1);
    }

    /*
     * WARNING - void declaration
     */
    public Enumerable<Object> query(final Session session, List<Map.Entry<String, Class>> fields, final List<Map.Entry<String, String>> selectFields, List<String> predicates, List<String> order, final Integer offset, Integer fetch) {
        void var13_18;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        final RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        final RelDataType rowType = (RelDataType)this.protoRowType.apply((Object)typeFactory);
        Function1<String, Void> addField = new Function1<String, Void>((RelDataTypeFactory)typeFactory){
            final /* synthetic */ RelDataTypeFactory val$typeFactory;
            {
                this.val$typeFactory = relDataTypeFactory;
            }

            public Void apply(String fieldName) {
                SqlTypeName typeName = rowType.getField(fieldName, true, false).getType().getSqlTypeName();
                fieldInfo.add(fieldName, this.val$typeFactory.createSqlType(typeName)).nullable(true);
                return null;
            }
        };
        if (selectFields.isEmpty()) {
            for (Map.Entry<String, Object> entry : fields) {
                addField.apply((Object)entry.getKey());
            }
        } else {
            for (Map.Entry<String, Object> entry : selectFields) {
                addField.apply((Object)entry.getKey());
            }
        }
        final RelProtoDataType resultRowType = RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
        if (selectFields.isEmpty()) {
            String string = "*";
        } else {
            String string = Util.toString((Iterable)new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    final Iterator selectIterator = selectFields.iterator();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return selectIterator.hasNext();
                        }

                        @Override
                        public String next() {
                            Map.Entry entry = (Map.Entry)selectIterator.next();
                            return (String)entry.getKey() + " AS " + (String)entry.getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }, (String)"", (String)", ", (String)"");
        }
        String whereClause = "";
        if (!predicates.isEmpty()) {
            whereClause = " WHERE ";
            whereClause = whereClause + Util.toString(predicates, (String)"", (String)" AND ", (String)"");
        }
        StringBuilder queryBuilder = new StringBuilder("SELECT ");
        queryBuilder.append((String)var13_18);
        queryBuilder.append(" FROM \"" + this.columnFamily + "\"");
        queryBuilder.append(whereClause);
        if (!order.isEmpty()) {
            queryBuilder.append(Util.toString(order, (String)" ORDER BY ", (String)", ", (String)""));
        }
        int limit = offset;
        if (fetch >= 0) {
            limit += fetch.intValue();
        }
        if (limit > 0) {
            queryBuilder.append(" LIMIT " + limit);
        }
        queryBuilder.append(" ALLOW FILTERING");
        final String query = queryBuilder.toString();
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                ResultSet results = session.execute(query);
                CassandraEnumerator enumerator = new CassandraEnumerator(results, resultRowType);
                for (int skip = 0; skip < offset && enumerator.moveNext(); ++skip) {
                }
                return enumerator;
            }
        };
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new CassandraQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new CassandraTableScan(cluster, cluster.traitSetOf((RelTrait)CassandraRel.CONVENTION), relOptTable, this, null);
    }

    public static class CassandraQueryable<T>
    extends AbstractTableQueryable<T> {
        public CassandraQueryable(QueryProvider queryProvider, SchemaPlus schema, CassandraTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable<Object> enumerable = this.getTable().query(this.getSession());
            return enumerable.enumerator();
        }

        private CassandraTable getTable() {
            return (CassandraTable)this.table;
        }

        private Session getSession() {
            return ((CassandraSchema)((Object)this.schema.unwrap(CassandraSchema.class))).session;
        }

        public Enumerable<Object> query(List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<String> predicates, List<String> order, Integer offset, Integer fetch) {
            return this.getTable().query(this.getSession(), fields, selectFields, predicates, order, offset, fetch);
        }
    }
}

