/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.LocalJsonService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JsonHandlerTest {
    private static final Random RANDOM = new Random();

    @Test
    public void testExecuteRequestWithNumberParameter() {
        ArrayList<TypedValue> expectedParameterValues = new ArrayList<TypedValue>();
        ParameterValuesCheckingService service = new ParameterValuesCheckingService(expectedParameterValues);
        LocalJsonService jsonService = new LocalJsonService((Service)service);
        JsonHandler jsonHandler = new JsonHandler((Service)jsonService);
        List<TypedValue> parameterValues = Arrays.asList(TypedValue.create((String)"NUMBER", (Object)new BigDecimal("123")), TypedValue.create((String)"STRING", (Object)"calcite"));
        jsonHandler.apply("{'request':'execute','parameterValues':[{'type':'NUMBER','value':123},{'type':'STRING','value':'calcite'}]}");
        Assert.assertThat((Object)expectedParameterValues.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(expectedParameterValues.get(0), (Matcher)CoreMatchers.is((Object)parameterValues.get(0)));
        Assert.assertThat(expectedParameterValues.get(1), (Matcher)CoreMatchers.is((Object)parameterValues.get(1)));
    }

    public static class ParameterValuesCheckingService
    extends NoopService {
        final List<TypedValue> expectedParameterValues;

        public ParameterValuesCheckingService(List<TypedValue> epv) {
            this.expectedParameterValues = epv;
        }

        @Override
        public Service.ExecuteResponse apply(Service.ExecuteRequest request) {
            this.expectedParameterValues.addAll(request.parameterValues);
            Meta.Signature signature = new Meta.Signature(Collections.emptyList(), "SELECT 1 FROM VALUE()", Collections.emptyList(), Collections.emptyMap(), Meta.CursorFactory.LIST, Meta.StatementType.SELECT);
            Service.ResultSetResponse resultSetResponse = new Service.ResultSetResponse(UUID.randomUUID().toString(), RANDOM.nextInt(), false, signature, Meta.Frame.EMPTY, -1L);
            return new Service.ExecuteResponse(Collections.singletonList(resultSetResponse), false);
        }
    }

    public static class NoopService
    implements Service {
        public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.SchemasRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TablesRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
            return null;
        }

        public Service.PrepareResponse apply(Service.PrepareRequest request) {
            return null;
        }

        public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
            return null;
        }

        public Service.FetchResponse apply(Service.FetchRequest request) {
            return null;
        }

        public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
            return null;
        }

        public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
            return null;
        }

        public Service.OpenConnectionResponse apply(Service.OpenConnectionRequest request) {
            return null;
        }

        public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
            return null;
        }

        public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
            return null;
        }

        public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
            return null;
        }

        public Service.SyncResultsResponse apply(Service.SyncResultsRequest request) {
            return null;
        }

        public Service.ExecuteResponse apply(Service.ExecuteRequest request) {
            return null;
        }
    }
}

