/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.test;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.avatica.ConnectStringParser;
import org.junit.Assert;
import org.junit.Test;

public class ConnectStringParserTest {
    @Test
    public void testSimpleStrings() throws Throwable {
        Properties props = ConnectStringParser.parse((String)"foo=x;bar=y;foo=z");
        Assert.assertEquals((String)"bar", (Object)"y", (Object)props.get("bar"));
        Assert.assertNull((String)"BAR", (Object)props.get("BAR"));
        Assert.assertEquals((String)"last foo", (Object)"z", (Object)props.get("foo"));
        Assert.assertNull((String)"key=\" bar\"", (Object)props.get(" bar"));
        Assert.assertNull((String)"bogus key", (Object)props.get("kipper"));
        Assert.assertEquals((String)"param count", (long)2L, (long)props.size());
        String synth = ConnectStringParser.getParamString((Properties)props);
        Properties synthProps = ConnectStringParser.parse((String)synth);
        Assert.assertEquals((String)"reversible", (Object)props, (Object)synthProps);
    }

    @Test
    public void testComplexStrings() throws Throwable {
        Properties props = ConnectStringParser.parse((String)"normalProp=value;emptyValue=; spaceBeforeProp=abc; spaceBeforeAndAfterProp =def; space in prop = foo bar ;equalsInValue=foo=bar;semiInProp;Name=value; singleQuotedValue = 'single quoted value ending in space ' ; doubleQuotedValue = \"=double quoted value preceded by equals\" ; singleQuotedValueWithSemi = 'one; two'; singleQuotedValueWithSpecials = 'one; two \"three''four=five'");
        Assert.assertEquals((String)"param count", (long)11L, (long)props.size());
        String value = (String)props.get("normalProp");
        Assert.assertEquals((Object)"value", (Object)value);
        value = (String)props.get("emptyValue");
        Assert.assertEquals((Object)"", (Object)value);
        value = (String)props.get("spaceBeforeProp");
        Assert.assertEquals((Object)"abc", (Object)value);
        value = (String)props.get("spaceBeforeAndAfterProp");
        Assert.assertEquals((Object)"def", (Object)value);
        value = (String)props.get("space in prop");
        Assert.assertEquals((Object)value, (Object)"foo bar");
        value = (String)props.get("equalsInValue");
        Assert.assertEquals((Object)"foo=bar", (Object)value);
        value = (String)props.get("semiInProp;Name");
        Assert.assertEquals((Object)"value", (Object)value);
        value = (String)props.get("singleQuotedValue");
        Assert.assertEquals((Object)"single quoted value ending in space ", (Object)value);
        value = (String)props.get("doubleQuotedValue");
        Assert.assertEquals((Object)"=double quoted value preceded by equals", (Object)value);
        value = (String)props.get("singleQuotedValueWithSemi");
        Assert.assertEquals((Object)value, (Object)"one; two");
        value = (String)props.get("singleQuotedValueWithSpecials");
        Assert.assertEquals((Object)value, (Object)"one; two \"three'four=five");
    }

    @Test
    public void testConnectStringErrors() throws Throwable {
        try {
            ConnectStringParser.parse((String)"key='can't parse'");
            Assert.fail((String)"quoted value ended too soon");
        }
        catch (SQLException e) {
            ConnectStringParserTest.assertExceptionMatches(e, ".*quoted value ended.*position 9.*");
        }
        try {
            ConnectStringParser.parse((String)"key='\"can''t parse\"");
            Assert.fail((String)"unterminated quoted value");
        }
        catch (SQLException e) {
            ConnectStringParserTest.assertExceptionMatches(e, ".*unterminated quoted value.*");
        }
    }

    @Test
    public void testOleDbExamples() throws Throwable {
        Quad[] quads;
        for (Quad quad : quads = new Quad[]{new Quad("printable chars", "Jet OLE DB:System Database", "c:\\system.mda", "Jet OLE DB:System Database=c:\\system.mda"), new Quad("key embedded semi", "Authentication;Info", "Column 5", "Authentication;Info=Column 5"), new Quad("key embedded equal", "Verification=Security", "True", "Verification==Security=True"), new Quad("key many equals", "Many==One", "Valid", "Many====One=Valid"), new Quad("key too many equal", "TooMany=", "False", "TooMany===False"), new Quad("value embedded quote and semi", "ExtProps", "Data Source='localhost';Key Two='value 2'", "ExtProps=\"Data Source='localhost';Key Two='value 2'\""), new Quad("value embedded double quote and semi", "ExtProps", "Integrated Security=\"SSPI\";Key Two=\"value 2\"", "ExtProps='Integrated Security=\"SSPI\";Key Two=\"value 2\"'"), new Quad("value double quoted", "DataSchema", "\"MyCustTable\"", "DataSchema='\"MyCustTable\"'"), new Quad("value single quoted", "DataSchema", "'MyCustTable'", "DataSchema=\"'MyCustTable'\""), new Quad("value double quoted double trouble", "Caption", "\"Company's \"new\" customer\"", "Caption=\"\"\"Company's \"\"new\"\" customer\"\"\""), new Quad("value single quoted double trouble", "Caption", "\"Company's \"new\" customer\"", "Caption='\"Company''s \"new\" customer\"'"), new Quad("embedded blanks and trim", "My Keyword", "My Value", " My Keyword = My Value ;MyNextValue=Value"), new Quad("value single quotes preserve blanks", "My Keyword", " My Value ", " My Keyword =' My Value ';MyNextValue=Value"), new Quad("value double quotes preserve blanks", "My Keyword", " My Value ", " My Keyword =\" My Value \";MyNextValue=Value"), new Quad("last redundant key wins", "SomeKey", "NextValue", "SomeKey=FirstValue;SomeKey=NextValue")}) {
            Properties props = ConnectStringParser.parse((String)quad.str);
            Assert.assertEquals((String)quad.why, (Object)quad.val, (Object)props.get(quad.key));
            String synth = ConnectStringParser.getParamString((Properties)props);
            try {
                Assert.assertEquals((String)("reversible " + quad.why), (Object)quad.str, (Object)synth);
            }
            catch (Throwable e) {
                Properties synthProps = ConnectStringParser.parse((String)synth);
                Assert.assertEquals((String)("equivalent " + quad.why), (Object)props, (Object)synthProps);
            }
        }
    }

    static void assertExceptionMatches(Throwable e, String expectedPattern) {
        String msg;
        if (e == null) {
            Assert.fail((String)("Expected an error which matches pattern '" + expectedPattern + "'"));
        }
        if (!(msg = e.toString()).matches(expectedPattern)) {
            Assert.fail((String)("Got a different error '" + msg + "' than expected '" + expectedPattern + "'"));
        }
    }

    static class Quad {
        private final String why;
        private final String key;
        private final String val;
        private final String str;

        Quad(String why, String key, String val, String str) {
            this.why = why;
            this.key = key;
            this.val = val;
            this.str = str;
        }
    }
}

