/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.nio.charset.StandardCharsets;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.avatica.util.ByteString;
import org.junit.Assert;
import org.junit.Test;

public class TypedValueTest {
    private void serializeAndEqualityCheck(TypedValue value) {
        TypedValue copy = TypedValue.fromProto((Common.TypedValue)value.toProto());
        Assert.assertEquals((Object)value.type, (Object)copy.type);
        Assert.assertEquals((Object)value.value, (Object)copy.value);
    }

    @Test
    public void testBoolean() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_BOOLEAN, (Object)true));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.BOOLEAN, (Object)Boolean.TRUE));
    }

    @Test
    public void testByte() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_BYTE, (Object)4));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.BYTE, (Object)4));
    }

    @Test
    public void testShort() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_SHORT, (Object)42));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.SHORT, (Object)42));
    }

    @Test
    public void testInteger() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_INT, (Object)42000));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.INTEGER, (Object)42000));
    }

    @Test
    public void testLong() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_LONG, (Object)Long.MAX_VALUE));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.LONG, (Object)Long.MAX_VALUE));
    }

    @Test
    public void testFloat() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_FLOAT, (Object)Float.valueOf(3.14159f)));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.FLOAT, (Object)Float.valueOf(3.14159f)));
    }

    @Test
    public void testDouble() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_DOUBLE, (Object)Double.MAX_VALUE));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.DOUBLE, (Object)Double.MAX_VALUE));
    }

    @Test
    public void testChar() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.PRIMITIVE_CHAR, (Object)Character.valueOf('c')));
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.CHARACTER, (Object)Character.valueOf('c')));
    }

    @Test
    public void testString() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.STRING, (Object)"qwertyasdf"));
    }

    @Test
    public void testByteString() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.BYTE_STRING, (Object)new ByteString("qwertyasdf".getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void testSqlDate() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.JAVA_SQL_DATE, (Object)25));
    }

    @Test
    public void testUtilDate() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.JAVA_UTIL_DATE, (Object)System.currentTimeMillis()));
    }

    @Test
    public void testSqlTime() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.JAVA_SQL_TIME, (Object)0x2A00000));
    }

    @Test
    public void testSqlTimestamp() {
        this.serializeAndEqualityCheck(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP, (Object)0xA80000000L));
    }
}

